/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;

public final class Rows {
    public static List<Object> toGroupKey(long timeStamp, InputRow inputRow) {
        TreeMap<String, ImmutableSortedSet> dims = new TreeMap<String, ImmutableSortedSet>();
        for (String dim : inputRow.getDimensions()) {
            ImmutableSortedSet dimValues = ImmutableSortedSet.copyOf(inputRow.getDimension(dim));
            if (dimValues.size() <= 0) continue;
            dims.put(dim, dimValues);
        }
        return ImmutableList.of((Object)timeStamp, dims);
    }

    public static List<String> objectToStrings(Object inputValue) {
        if (inputValue == null) {
            return Collections.emptyList();
        }
        if (inputValue instanceof List) {
            return ((List)inputValue).stream().map(String::valueOf).collect(Collectors.toList());
        }
        if (inputValue instanceof byte[]) {
            return Collections.singletonList(StringUtils.encodeBase64String((byte[])inputValue));
        }
        if (inputValue instanceof Object[]) {
            return Arrays.stream((Object[])inputValue).map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.singletonList(String.valueOf(inputValue));
    }

    @Nullable
    public static <T extends Number> Number objectToNumber(String name, Object inputValue, boolean throwParseExceptions) {
        if (inputValue == null) {
            return NullHandling.defaultLongValue();
        }
        if (inputValue instanceof Number) {
            return (Number)inputValue;
        }
        if (inputValue instanceof String) {
            try {
                String metricValueString = StringUtils.removeChar(((String)inputValue).trim(), ',');
                metricValueString = Rows.trimLeadingPlusOfLongString(metricValueString);
                Long v = Longs.tryParse((String)metricValueString);
                if (v != null) {
                    return v;
                }
                return Double.valueOf(metricValueString);
            }
            catch (Exception e) {
                if (throwParseExceptions) {
                    throw new ParseException(String.valueOf(inputValue), (Throwable)e, "Unable to parse value[%s] for field[%s]", inputValue, name);
                }
                return NullHandling.defaultLongValue();
            }
        }
        if (throwParseExceptions) {
            throw new ParseException(String.valueOf(inputValue), "Unknown type[%s] for field[%s]", inputValue.getClass(), name);
        }
        return NullHandling.defaultLongValue();
    }

    private static String trimLeadingPlusOfLongString(String metricValueString) {
        char secondChar;
        if (metricValueString.length() > 1 && metricValueString.charAt(0) == '+' && (secondChar = metricValueString.charAt(1)) >= '0' && secondChar <= '9') {
            metricValueString = metricValueString.substring(1);
        }
        return metricValueString;
    }

    private Rows() {
    }
}

