/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.CollectionUtils;

public class JsonNodeReader
extends IntermediateRowParsingReader<JsonNode> {
    private final ObjectFlattener<JsonNode> flattener;
    private final ObjectMapper mapper;
    private final InputEntity source;
    private final InputRowSchema inputRowSchema;
    private final JsonFactory jsonFactory;

    JsonNodeReader(InputRowSchema inputRowSchema, InputEntity source, JSONPathSpec flattenSpec, ObjectMapper mapper, boolean keepNullColumns) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker(keepNullColumns, inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
        this.mapper = mapper;
        this.jsonFactory = new JsonFactory();
    }

    @Override
    protected CloseableIterator<JsonNode> intermediateRowIterator() throws IOException {
        String sourceString = IOUtils.toString((InputStream)this.source.open(), (String)StringUtils.UTF8_STRING);
        ArrayList<Object> jsonNodes = new ArrayList<Object>();
        try {
            JsonParser parser = this.jsonFactory.createParser(sourceString);
            MappingIterator delegate = this.mapper.readValues(parser, JsonNode.class);
            while (delegate.hasNext()) {
                jsonNodes.add((JsonNode)delegate.next());
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof JsonParseException) {
                jsonNodes.add((Object)new ParseExceptionMarkerJsonNode(new ParseException(sourceString, (Throwable)e, "Unable to parse row [%s]", sourceString)));
            }
            throw e;
        }
        if (CollectionUtils.isNullOrEmpty(jsonNodes)) {
            jsonNodes.add((Object)new ParseExceptionMarkerJsonNode(new ParseException(sourceString, "Unable to parse [%s] as the intermediateRow resulted in empty input row", sourceString)));
        }
        return CloseableIterators.withEmptyBaggage(jsonNodes.iterator());
    }

    @Override
    protected InputEntity source() {
        return this.source;
    }

    @Override
    protected List<InputRow> parseInputRows(JsonNode intermediateRow) throws ParseException {
        if (intermediateRow instanceof ParseExceptionMarkerJsonNode) {
            throw ((ParseExceptionMarkerJsonNode)intermediateRow).getParseException();
        }
        List<InputRow> inputRows = Collections.singletonList(MapInputRowParser.parse(this.inputRowSchema, this.flattener.flatten(intermediateRow)));
        if (CollectionUtils.isNullOrEmpty(inputRows)) {
            throw new ParseException(intermediateRow.toString(), "Unable to parse [%s] as the intermediateRow resulted in empty input row", intermediateRow.toString());
        }
        return inputRows;
    }

    @Override
    protected List<Map<String, Object>> toMap(JsonNode intermediateRow) throws IOException {
        if (intermediateRow instanceof ParseExceptionMarkerJsonNode) {
            throw ((ParseExceptionMarkerJsonNode)intermediateRow).getParseException();
        }
        return Collections.singletonList((Map)this.mapper.readValue(intermediateRow.toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    private static class ParseExceptionMarkerJsonNode
    extends ObjectNode {
        final ParseException parseException;

        public ParseExceptionMarkerJsonNode(ParseException pe) {
            super(null);
            this.parseException = pe;
        }

        public ParseException getParseException() {
            return this.parseException;
        }
    }
}

