/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.java.util.common.IAE;

public class ReadableFileFrameChannel
implements ReadableFrameChannel {
    private final FrameFile frameFile;
    private final int endFrame;
    private int currentFrame;

    public ReadableFileFrameChannel(FrameFile frameFile, int startFrame, int endFrame) {
        this.frameFile = frameFile;
        this.currentFrame = startFrame;
        this.endFrame = endFrame;
        if (startFrame < 0) {
            throw new IAE("startFrame[%,d] < 0", startFrame);
        }
        if (startFrame > endFrame) {
            throw new IAE("startFrame[%,d] > endFrame[%,d]", startFrame, endFrame);
        }
        if (endFrame > frameFile.numFrames()) {
            throw new IAE("endFrame[%,d] > numFrames[%,d]", endFrame, frameFile.numFrames());
        }
    }

    public ReadableFileFrameChannel(FrameFile frameFile) {
        this(frameFile, 0, frameFile.numFrames());
    }

    @Override
    public boolean isFinished() {
        return this.currentFrame == this.endFrame;
    }

    @Override
    public boolean canRead() {
        return !this.isFinished();
    }

    @Override
    public Frame read() {
        if (this.isFinished()) {
            throw new NoSuchElementException();
        }
        return this.frameFile.frame(this.currentFrame++);
    }

    @Override
    public ListenableFuture<?> readabilityFuture() {
        return Futures.immediateFuture((Object)true);
    }

    @Override
    public void close() {
        try {
            this.frameFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FrameFile newFrameFileReference() {
        return this.frameFile.newReference();
    }
}

