/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.filter.BoundFilter;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.Interval;

public class FrameCursorUtils {
    private FrameCursorUtils() {
    }

    @Nullable
    public static Filter buildFilter(@Nullable Filter filter, Interval interval) {
        if (Intervals.ETERNITY.equals((Object)interval)) {
            return filter;
        }
        return Filters.and(Arrays.asList(new BoundFilter(new BoundDimFilter("__time", String.valueOf(interval.getStartMillis()), String.valueOf(interval.getEndMillis()), false, true, null, null, StringComparators.NUMERIC)), filter));
    }

    public static Sequence<Frame> cursorToFrames(final Cursor cursor, final FrameWriterFactory frameWriterFactory) {
        return Sequences.simple(() -> new Iterator<Frame>(){

            @Override
            public boolean hasNext() {
                return !cursor.isDone();
            }

            @Override
            public Frame next() {
                Frame frame;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                boolean firstRowWritten = false;
                try (FrameWriter frameWriter = frameWriterFactory.newFrameWriter(cursor.getColumnSelectorFactory());){
                    while (!cursor.isDone() && frameWriter.addSelection()) {
                        firstRowWritten = true;
                        cursor.advance();
                    }
                    if (!firstRowWritten) {
                        throw DruidException.forPersona(DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build("Subquery's row size exceeds the frame size and therefore cannot write the subquery's row to the frame. This is a non-configurable static limit that can only be modified by the developer.", new Object[0]);
                    }
                    frame = Frame.wrap(frameWriter.toByteArray());
                }
                return frame;
            }
        });
    }
}

