/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;

public class DurableStorageUtils {
    public static final String SUCCESS_MARKER_FILENAME = "__success";
    public static final Splitter SPLITTER = Splitter.on((String)"/").limit(3);
    public static final String QUERY_RESULTS_DIR = "query-results";

    public static String getControllerDirectory(String controllerTaskId) {
        return StringUtils.format("controller_%s", IdUtils.validateId("controller task ID", controllerTaskId));
    }

    private static String getQueryResultsControllerDirectory(String controllerTaskId) {
        return StringUtils.format("%s/controller_%s", QUERY_RESULTS_DIR, IdUtils.validateId("controller task ID", controllerTaskId));
    }

    public static String getWorkerOutputSuccessFilePath(String controllerTaskId, int stageNumber, int workerNumber) {
        String folderName = DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber);
        return StringUtils.format("%s/%s", folderName, SUCCESS_MARKER_FILENAME);
    }

    public static String getQueryResultsSuccessFilePath(String controllerTaskId, int stageNumber, int workerNumber) {
        String folderName = DurableStorageUtils.getQueryResultsWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber);
        return StringUtils.format("%s/%s", folderName, SUCCESS_MARKER_FILENAME);
    }

    private static String getWorkerOutputFolderName(String controllerTaskId, int stageNumber, int workerNumber) {
        return StringUtils.format("%s/stage_%d/worker_%d", DurableStorageUtils.getControllerDirectory(controllerTaskId), stageNumber, workerNumber);
    }

    private static String getQueryResultsWorkerOutputFolderName(String controllerTaskId, int stageNumber, int workerNumber) {
        return StringUtils.format("%s/stage_%d/worker_%d", DurableStorageUtils.getQueryResultsControllerDirectory(controllerTaskId), stageNumber, workerNumber);
    }

    public static String getTaskIdOutputsFolderName(String controllerTaskId, int stageNumber, int workerNumber, String taskId) {
        return StringUtils.format("%s/taskId_%s", DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber), taskId);
    }

    public static String getQueryResultsForTaskIdFolderName(String controllerTaskId, int stageNumber, int workerNumber, String taskId) {
        return StringUtils.format("%s/taskId_%s", DurableStorageUtils.getQueryResultsWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber), taskId);
    }

    public static String getPartitionOutputsFileNameWithPathForPartition(String controllerTaskId, int stageNumber, int workerNumber, String taskId, int partitionNumber) {
        return StringUtils.format("%s/part_%d", DurableStorageUtils.getTaskIdOutputsFolderName(controllerTaskId, stageNumber, workerNumber, taskId), partitionNumber);
    }

    public static String getQueryResultsFileNameWithPathForPartition(String controllerTaskId, int stageNumber, int workerNumber, String taskId, int partitionNumber) {
        return StringUtils.format("%s/part_%d", DurableStorageUtils.getQueryResultsForTaskIdFolderName(controllerTaskId, stageNumber, workerNumber, taskId), partitionNumber);
    }

    public static String getOutputsFileNameForPath(String controllerTaskId, int stageNumber, int workerNumber, String taskId, String path) {
        return StringUtils.format("%s/%s", DurableStorageUtils.getTaskIdOutputsFolderName(controllerTaskId, stageNumber, workerNumber, taskId), path);
    }

    @Nullable
    public static String getNextDirNameWithPrefixFromPath(String path) {
        if (path == null) {
            return null;
        }
        Iterator elements = SPLITTER.split((CharSequence)path).iterator();
        if (elements.hasNext()) {
            return (String)elements.next();
        }
        return null;
    }

    public static boolean isQueryResultFileActive(String path, Set<String> knownTasks) {
        if (path == null) {
            return false;
        }
        Iterator elementsIterator = SPLITTER.split((CharSequence)path).iterator();
        ImmutableList elements = ImmutableList.copyOf(elementsIterator);
        if (elements.size() < 2) {
            return false;
        }
        if (!QUERY_RESULTS_DIR.equals(elements.get(0))) {
            return false;
        }
        return knownTasks.contains(elements.get(1));
    }
}

