/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.List;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerProvider;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.NestedDataColumnHandlerV4;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataJsonSerializer;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;

public class NestedDataModule
implements DruidModule {
    @Override
    public List<? extends Module> getJacksonModules() {
        return NestedDataModule.getJacksonModulesList();
    }

    public void configure(Binder binder) {
        NestedDataModule.registerSerde();
        LifecycleModule.register(binder, SideEffectHandlerRegisterer.class);
    }

    @Provides
    @LazySingleton
    public SideEffectHandlerRegisterer registerHandler(DefaultColumnFormatConfig formatsConfig) {
        if (formatsConfig.getNestedColumnFormatVersion() != null && formatsConfig.getNestedColumnFormatVersion() == 4) {
            DimensionHandlerUtils.registerDimensionHandlerProvider("json", new NestedColumnV4HandlerProvider());
        } else {
            DimensionHandlerUtils.registerDimensionHandlerProvider("json", new NestedCommonFormatHandlerProvider());
        }
        return new SideEffectHandlerRegisterer();
    }

    public static List<SimpleModule> getJacksonModulesList() {
        return Collections.singletonList(new SimpleModule("NestedDataModule").registerSubtypes(new NamedType[]{new NamedType(NestedFieldVirtualColumn.class, "nested-field")}).addSerializer(StructuredData.class, (JsonSerializer)new StructuredDataJsonSerializer()));
    }

    @VisibleForTesting
    public static void registerHandlersAndSerde() {
        NestedDataModule.registerSerde();
        DimensionHandlerUtils.registerDimensionHandlerProvider("json", new NestedCommonFormatHandlerProvider());
    }

    private static void registerSerde() {
        if (ComplexMetrics.getSerdeForType("json") == null) {
            ComplexMetrics.registerSerde("json", NestedDataComplexTypeSerde.INSTANCE);
        }
    }

    public static class SideEffectHandlerRegisterer {
    }

    public static class NestedColumnV4HandlerProvider
    implements DimensionHandlerProvider<StructuredData, StructuredData, StructuredData> {
        @Override
        public DimensionHandler<StructuredData, StructuredData, StructuredData> get(String dimensionName) {
            return new NestedDataColumnHandlerV4(dimensionName);
        }
    }

    public static class NestedCommonFormatHandlerProvider
    implements DimensionHandlerProvider<StructuredData, StructuredData, StructuredData> {
        @Override
        public DimensionHandler<StructuredData, StructuredData, StructuredData> get(String dimensionName) {
            return new NestedCommonFormatColumnHandler(dimensionName);
        }
    }
}

