/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.StringExpr;
import org.apache.druid.segment.column.TypeStrategy;

public class BuiltInExprMacros {

    public static class StringDecodeBase64UTFExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "decode_base64_utf8";

        @Override
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            return new StringDecodeBase64UTFExpression(args.get(0));
        }

        @Override
        public String name() {
            return NAME;
        }

        final class StringDecodeBase64UTFExpression
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            public StringDecodeBase64UTFExpression(Expr arg) {
                super(StringDecodeBase64UTFExprMacro.this.name(), arg);
            }

            @Override
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval toDecode = this.arg.eval(bindings);
                if (toDecode.value() == null) {
                    return ExprEval.of(null);
                }
                return new StringExpr(StringUtils.fromUtf8(StringUtils.decodeBase64String(toDecode.asString()))).eval(bindings);
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(StringDecodeBase64UTFExprMacro.this.apply(shuttle.visitAll(Collections.singletonList(this.arg))));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }

            @Override
            public boolean isLiteral() {
                return this.arg.isLiteral();
            }

            @Override
            public boolean isNullLiteral() {
                return this.arg.isNullLiteral();
            }

            @Override
            @Nullable
            public Object getLiteralValue() {
                return this.eval(InputBindings.nilBindings()).value();
            }
        }
    }

    public static class ComplexDecodeBase64ExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "complex_decode_base64";
        public static final String ALIAS = "decode_base64_complex";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            return new ComplexDecodeBase64Expression(args);
        }

        final class ComplexDecodeBase64Expression
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private final ExpressionType complexType;
            private final TypeStrategy<?> typeStrategy;

            public ComplexDecodeBase64Expression(List<Expr> args) {
                super(ComplexDecodeBase64ExprMacro.this.name(), args);
                ComplexDecodeBase64ExprMacro.this.validationHelperCheckArgumentCount(args, 2);
                Expr arg0 = args.get(0);
                if (!arg0.isLiteral()) {
                    throw ComplexDecodeBase64ExprMacro.this.validationFailed("first argument must be constant STRING expression containing a valid complex type name but got '%s' instead", arg0.stringify());
                }
                if (arg0.isNullLiteral()) {
                    throw ComplexDecodeBase64ExprMacro.this.validationFailed("first argument must be constant STRING expression containing a valid complex type name but got NULL instead", new Object[0]);
                }
                Object literal = arg0.getLiteralValue();
                if (!(literal instanceof String)) {
                    throw ComplexDecodeBase64ExprMacro.this.validationFailed("first argument must be constant STRING expression containing a valid complex type name but got '%s' instead", arg0.getLiteralValue());
                }
                this.complexType = ExpressionTypeFactory.getInstance().ofComplex((String)literal);
                try {
                    this.typeStrategy = this.complexType.getStrategy();
                }
                catch (IllegalArgumentException illegal) {
                    throw ComplexDecodeBase64ExprMacro.this.validationFailed("first argument must be a valid COMPLEX type name, got unknown COMPLEX type [%s]", this.complexType.asTypeString());
                }
            }

            @Override
            public ExprEval<?> eval(Expr.ObjectBinding bindings) {
                byte[] base64;
                ExprEval toDecode = ((Expr)this.args.get(1)).eval(bindings);
                if (toDecode.value() == null) {
                    return ExprEval.ofComplex(this.complexType, null);
                }
                Object serializedValue = toDecode.value();
                if (serializedValue instanceof String) {
                    base64 = StringUtils.decodeBase64String(toDecode.asString());
                } else if (serializedValue instanceof byte[]) {
                    base64 = (byte[])serializedValue;
                } else {
                    if (this.complexType.getComplexTypeName().equals(toDecode.type().getComplexTypeName())) {
                        return toDecode;
                    }
                    throw ComplexDecodeBase64ExprMacro.this.validationFailed("second argument must be a base64 encoded STRING value but got %s instead", toDecode.type());
                }
                return ExprEval.ofComplex(this.complexType, this.typeStrategy.fromBytes(base64));
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
                return shuttle.visit(new ComplexDecodeBase64Expression(newArgs));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return this.complexType;
            }

            @Override
            public boolean isLiteral() {
                return ((Expr)this.args.get(1)).isLiteral();
            }

            @Override
            public boolean isNullLiteral() {
                return ((Expr)this.args.get(1)).isNullLiteral();
            }

            @Override
            @Nullable
            public Object getLiteralValue() {
                return this.eval(InputBindings.nilBindings()).value();
            }
        }
    }
}

