/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

class FunctionExpr
implements Expr {
    final Function function;
    final ImmutableList<Expr> args;
    private final String name;

    FunctionExpr(Function function, String name, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.args = ImmutableList.copyOf(args);
        function.validateArguments(args);
    }

    public String toString() {
        return StringUtils.format("(%s %s)", this.name, this.args);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply((List<Expr>)this.args, bindings);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return this.function.canVectorize(inspector, (List<Expr>)this.args);
    }

    public ExprVectorProcessor<?> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return this.function.asVectorProcessor(inspector, (List<Expr>)this.args);
    }

    @Override
    public String stringify() {
        return StringUtils.format("%s(%s)", this.name, ARG_JOINER.join(this.args.stream().map(Expr::stringify).iterator()));
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(new FunctionExpr(this.function, this.name, shuttle.visitAll((List<Expr>)this.args)));
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        Expr.BindingAnalysis accumulator = new Expr.BindingAnalysis();
        for (Expr arg : this.args) {
            accumulator = accumulator.with(arg);
        }
        return accumulator.withScalarArguments(this.function.getScalarInputs((List<Expr>)this.args)).withArrayArguments(this.function.getArrayInputs((List<Expr>)this.args)).withArrayInputs(this.function.hasArrayInputs()).withArrayOutput(this.function.hasArrayOutput());
    }

    @Override
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.function.getOutputType(inspector, (List<Expr>)this.args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpr that = (FunctionExpr)o;
        return this.args.equals(that.args) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.name);
    }
}

