/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.vector.CastToDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.CastToLongVectorProcessor;
import org.apache.druid.math.expr.vector.CastToStringVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class CastToTypeVectorProcessor<TOutput>
implements ExprVectorProcessor<TOutput> {
    protected final ExprVectorProcessor<?> delegate;

    protected CastToTypeVectorProcessor(ExprVectorProcessor<?> delegate) {
        this.delegate = delegate;
    }

    public static <T> ExprVectorProcessor<T> cast(ExprVectorProcessor<?> delegate, ExpressionType type) {
        CastToTypeVectorProcessor caster;
        if (delegate.getOutputType().equals(type)) {
            caster = delegate;
        } else {
            switch ((ExprType)type.getType()) {
                case STRING: {
                    caster = new CastToStringVectorProcessor(delegate);
                    break;
                }
                case LONG: {
                    caster = new CastToLongVectorProcessor(delegate);
                    break;
                }
                case DOUBLE: {
                    caster = new CastToDoubleVectorProcessor(delegate);
                    break;
                }
                default: {
                    throw Exprs.cannotVectorize();
                }
            }
        }
        return caster;
    }
}

