/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringBufferStore;
import org.apache.druid.query.aggregation.SerializablePairLongStringSimpleStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SerializablePairLongStringColumnSerializer
implements GenericColumnSerializer<SerializablePairLongString> {
    public static final StagedSerde<SerializablePairLongString> STAGED_SERDE = new SerializablePairLongStringSimpleStagedSerde();
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ByteBufferProvider byteBufferProvider;
    private State state = State.START;
    private SerializablePairLongStringBufferStore bufferStore;
    private SerializablePairLongStringBufferStore.TransferredBuffer transferredBuffer;

    public SerializablePairLongStringColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, ByteBufferProvider byteBufferProvider) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.byteBufferProvider = byteBufferProvider;
    }

    @Override
    public void open() throws IOException {
        Preconditions.checkState((this.state == State.START || this.state == State.OPEN ? 1 : 0) != 0, (String)"open called in invalid state %s", (Object)((Object)this.state));
        if (this.state == State.START) {
            this.bufferStore = new SerializablePairLongStringBufferStore(new SerializedStorage<SerializablePairLongString>(this.segmentWriteOutMedium.makeWriteOutBytes(), STAGED_SERDE));
            this.state = State.OPEN;
        }
    }

    @Override
    public void serialize(ColumnValueSelector<? extends SerializablePairLongString> selector) throws IOException {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0, (String)"serialize called in invalid state %s", (Object)((Object)this.state));
        SerializablePairLongString pairLongString = (SerializablePairLongString)selector.getObject();
        this.bufferStore.store(pairLongString);
    }

    @Override
    public long getSerializedSize() throws IOException {
        Preconditions.checkState((this.state != State.START ? 1 : 0) != 0, (String)"getSerializedSize called in invalid state %s (must have opened at least)", (Object)((Object)this.state));
        this.transferToRowWriterIfNecessary();
        return this.transferredBuffer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, @Nullable FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((this.state != State.START ? 1 : 0) != 0, (String)"writeTo called in invalid state %s", (Object)((Object)this.state));
        this.transferToRowWriterIfNecessary();
        this.transferredBuffer.writeTo(channel, smoosher);
    }

    private void transferToRowWriterIfNecessary() throws IOException {
        if (this.state == State.OPEN) {
            this.transferredBuffer = this.bufferStore.transferToRowWriter(this.byteBufferProvider, this.segmentWriteOutMedium);
            this.state = State.CLOSED;
        }
    }

    private static enum State {
        START,
        OPEN,
        CLOSED;

    }
}

