/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringAnyBufferAggregator
implements BufferAggregator {
    private static final int FOUND_AND_NULL_FLAG_VALUE = -1;
    private static final int NOT_FOUND_FLAG_VALUE = -2;
    private static final int FOUND_VALUE_OFFSET = 4;
    private final BaseObjectColumnValueSelector valueSelector;
    private final int maxStringBytes;

    public StringAnyBufferAggregator(BaseObjectColumnValueSelector valueSelector, int maxStringBytes) {
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putInt(position, -2);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (buf.getInt(position) == -2) {
            Object object = this.valueSelector.getObject();
            String foundValue = DimensionHandlerUtils.convertObjectToString(object);
            if (foundValue != null) {
                ByteBuffer mutationBuffer = buf.duplicate();
                mutationBuffer.position(position + 4);
                mutationBuffer.limit(position + 4 + this.maxStringBytes);
                int len = StringUtils.toUtf8WithLimit(foundValue, mutationBuffer);
                mutationBuffer.putInt(position, len);
            } else {
                buf.putInt(position, -1);
            }
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        ByteBuffer copyBuffer = buf.duplicate();
        copyBuffer.position(position);
        int stringSizeBytes = copyBuffer.getInt();
        if (stringSizeBytes >= 0) {
            byte[] valueBytes = new byte[stringSizeBytes];
            copyBuffer.get(valueBytes, 0, stringSizeBytes);
            return StringUtils.fromUtf8(valueBytes);
        }
        return null;
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringAnyBufferAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

