/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.first.StringFirstLastUtils;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class StringFirstVectorAggregator
implements VectorAggregator {
    private static final SerializablePairLongString INIT = new SerializablePairLongString(DateTimes.MAX.getMillis(), null);
    private final VectorValueSelector timeSelector;
    private final VectorObjectSelector valueSelector;
    private final int maxStringBytes;

    public StringFirstVectorAggregator(VectorValueSelector timeSelector, VectorObjectSelector valueSelector, int maxStringBytes) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        StringFirstLastUtils.writePair(buf, position, INIT, this.maxStringBytes);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if (this.timeSelector == null) {
            return;
        }
        long[] times = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        Object[] objectsWhichMightBeStrings = this.valueSelector.getObjectVector();
        long firstTime = buf.getLong(position);
        for (int i = startRow; i < endRow; ++i) {
            if (times[i] > firstTime || nullTimeVector != null && nullTimeVector[i]) continue;
            int index = i;
            boolean foldNeeded = StringFirstLastUtils.objectNeedsFoldCheck(objectsWhichMightBeStrings[index]);
            if (foldNeeded) {
                SerializablePairLongString inPair = StringFirstLastUtils.readPairFromVectorSelectorsAtIndex(this.timeSelector, this.valueSelector, index);
                if (inPair == null) continue;
                firstTime = buf.getLong(position);
                if ((Long)inPair.lhs >= firstTime) continue;
                StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString((Long)inPair.lhs, (String)inPair.rhs), this.maxStringBytes);
                continue;
            }
            long time = times[index];
            if (time >= firstTime) continue;
            String value = DimensionHandlerUtils.convertObjectToString(objectsWhichMightBeStrings[index]);
            firstTime = time;
            StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, value), this.maxStringBytes);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        Object[] objectsWhichMightBeStrings = this.valueSelector.getObjectVector();
        boolean foldNeeded = false;
        for (Object obj : objectsWhichMightBeStrings) {
            if (obj == null) continue;
            foldNeeded = StringFirstLastUtils.objectNeedsFoldCheck(obj);
            break;
        }
        for (int i = 0; i < numRows; ++i) {
            int position;
            long firstTime;
            if (nullTimeVector != null && nullTimeVector[i]) continue;
            int row = rows == null ? i : rows[i];
            if (timeVector[row] >= (firstTime = buf.getLong(position = positions[i] + positionOffset))) continue;
            if (foldNeeded) {
                SerializablePairLongString inPair = StringFirstLastUtils.readPairFromVectorSelectorsAtIndex(this.timeSelector, this.valueSelector, row);
                if (inPair == null || (Long)inPair.lhs >= firstTime) continue;
                StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString((Long)inPair.lhs, (String)inPair.rhs), this.maxStringBytes);
                continue;
            }
            String value = DimensionHandlerUtils.convertObjectToString(objectsWhichMightBeStrings[row]);
            firstTime = timeVector[row];
            StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(firstTime, value), this.maxStringBytes);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return StringFirstLastUtils.readPair(buf, position);
    }

    @Override
    public void close() {
    }
}

