/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class SingleStringLastDimensionVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector timeSelector;
    private final SingleValueDimensionVectorSelector valueDimensionVectorSelector;
    private long lastTime;
    private final int maxStringBytes;
    private final boolean useDefault = NullHandling.replaceWithDefault();

    public SingleStringLastDimensionVectorAggregator(VectorValueSelector timeSelector, SingleValueDimensionVectorSelector valueDimensionVectorSelector, int maxStringBytes) {
        this.timeSelector = timeSelector;
        this.valueDimensionVectorSelector = valueDimensionVectorSelector;
        this.maxStringBytes = maxStringBytes;
        this.lastTime = Long.MIN_VALUE;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MIN_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        buf.putInt(position + 9, 0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        int[] valueVector = this.valueDimensionVectorSelector.getRowVector();
        this.lastTime = buf.getLong(position);
        for (int index = endRow - 1; index >= startRow; --index) {
            long latestTime;
            if (nullTimeVector != null && nullTimeVector[index] || (latestTime = timeVector[index]) <= this.lastTime) continue;
            this.lastTime = latestTime;
            buf.putLong(position, this.lastTime);
            buf.put(position + 8, (byte)0);
            buf.putInt(position + 9, valueVector[index]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        int[] values = this.valueDimensionVectorSelector.getRowVector();
        for (int i = numRows - 1; i >= 0; --i) {
            if (nullTimeVector != null && nullTimeVector[i]) continue;
            int position = positions[i] + positionOffset;
            int row = rows == null ? i : rows[i];
            this.lastTime = buf.getLong(position);
            if (timeVector[row] <= this.lastTime) continue;
            this.lastTime = timeVector[row];
            buf.putLong(position, this.lastTime);
            buf.put(position + 8, (byte)0);
            buf.putInt(position + 9, values[row]);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        int index = buf.getInt(position + 9);
        long earliest = buf.getLong(position);
        String strValue = this.valueDimensionVectorSelector.lookupName(index);
        return new SerializablePairLongString(earliest, StringUtils.chop(strValue, this.maxStringBytes));
    }

    @Override
    public void close() {
    }
}

