/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.StringUtils;

public class CacheKeyBuilder {
    static final byte BYTE_KEY = 0;
    static final byte BYTE_ARRAY_KEY = 1;
    static final byte BOOLEAN_KEY = 2;
    static final byte INT_KEY = 3;
    static final byte FLOAT_KEY = 4;
    static final byte FLOAT_ARRAY_KEY = 5;
    static final byte DOUBLE_KEY = 6;
    static final byte STRING_KEY = 7;
    static final byte STRING_LIST_KEY = 8;
    static final byte CACHEABLE_KEY = 9;
    static final byte CACHEABLE_LIST_KEY = 10;
    static final byte DOUBLE_ARRAY_KEY = 11;
    static final byte LONG_KEY = 12;
    static final byte[] STRING_SEPARATOR = new byte[]{-1};
    static final byte[] EMPTY_BYTES = StringUtils.EMPTY_BYTES;
    private final List<Item> items = new ArrayList<Item>();
    private final byte id;
    private int size;

    private static byte[] floatArrayToByteArray(float[] input) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * input.length);
        buffer.asFloatBuffer().put(input);
        return buffer.array();
    }

    private static byte[] doubleArrayToByteArray(double[] input) {
        ByteBuffer buffer = ByteBuffer.allocate(8 * input.length);
        buffer.asDoubleBuffer().put(input);
        return buffer.array();
    }

    private static byte[] cacheableToByteArray(@Nullable Cacheable cacheable) {
        if (cacheable == null) {
            return EMPTY_BYTES;
        }
        byte[] key = cacheable.getCacheKey();
        Preconditions.checkArgument((!Arrays.equals(key, EMPTY_BYTES) ? 1 : 0) != 0, (Object)"cache key is equal to the empty key");
        return key;
    }

    private static byte[] stringCollectionToByteArray(@Nullable Collection<String> input, boolean preserveOrder) {
        return CacheKeyBuilder.collectionToByteArray(input, StringUtils::toUtf8WithNullToEmpty, STRING_SEPARATOR, preserveOrder);
    }

    private static byte[] cacheableCollectionToByteArray(@Nullable Collection<? extends Cacheable> input, boolean preserveOrder) {
        return CacheKeyBuilder.collectionToByteArray(input, CacheKeyBuilder::cacheableToByteArray, EMPTY_BYTES, preserveOrder);
    }

    private static <T> byte[] collectionToByteArray(@Nullable Collection<? extends T> collection, Function<T, byte[]> serializeFunction, byte[] separator, boolean preserveOrder) {
        if (collection != null && collection.size() > 0) {
            ArrayList byteArrayList = Lists.newArrayListWithCapacity((int)collection.size());
            int totalByteLength = 0;
            for (T eachItem : collection) {
                byte[] byteArray = (byte[])serializeFunction.apply(eachItem);
                totalByteLength += byteArray.length;
                byteArrayList.add(byteArray);
            }
            if (!preserveOrder) {
                Collections.sort(byteArrayList, UnsignedBytes.lexicographicalComparator());
            }
            Iterator iterator = byteArrayList.iterator();
            int bufSize = 4 + separator.length * (byteArrayList.size() - 1) + totalByteLength;
            ByteBuffer buffer = ByteBuffer.allocate(bufSize).putInt(byteArrayList.size()).put((byte[])iterator.next());
            while (iterator.hasNext()) {
                buffer.put(separator).put((byte[])iterator.next());
            }
            return buffer.array();
        }
        return EMPTY_BYTES;
    }

    public CacheKeyBuilder(byte id) {
        this.id = id;
        this.size = 1;
    }

    public CacheKeyBuilder appendByte(byte input) {
        this.appendItem((byte)0, new byte[]{input});
        return this;
    }

    public CacheKeyBuilder appendByteArray(byte[] input) {
        this.appendItem((byte)1, input);
        return this;
    }

    public CacheKeyBuilder appendString(@Nullable String input) {
        this.appendItem((byte)7, StringUtils.toUtf8WithNullToEmpty(input));
        return this;
    }

    public CacheKeyBuilder appendStrings(Collection<String> input) {
        this.appendItem((byte)8, CacheKeyBuilder.stringCollectionToByteArray(input, true));
        return this;
    }

    public CacheKeyBuilder appendStringsIgnoringOrder(Collection<String> input) {
        this.appendItem((byte)8, CacheKeyBuilder.stringCollectionToByteArray(input, false));
        return this;
    }

    public CacheKeyBuilder appendBoolean(boolean input) {
        this.appendItem((byte)2, new byte[]{(byte)(input ? 1 : 0)});
        return this;
    }

    public CacheKeyBuilder appendInt(int input) {
        this.appendItem((byte)3, Ints.toByteArray((int)input));
        return this;
    }

    public CacheKeyBuilder appendLong(long input) {
        this.appendItem((byte)12, Longs.toByteArray((long)input));
        return this;
    }

    public CacheKeyBuilder appendFloat(float input) {
        this.appendItem((byte)4, ByteBuffer.allocate(4).putFloat(input).array());
        return this;
    }

    public CacheKeyBuilder appendDouble(double input) {
        this.appendItem((byte)6, ByteBuffer.allocate(8).putDouble(input).array());
        return this;
    }

    public CacheKeyBuilder appendDoubleArray(double[] input) {
        this.appendItem((byte)11, CacheKeyBuilder.doubleArrayToByteArray(input));
        return this;
    }

    public CacheKeyBuilder appendFloatArray(float[] input) {
        this.appendItem((byte)5, CacheKeyBuilder.floatArrayToByteArray(input));
        return this;
    }

    public CacheKeyBuilder appendCacheable(@Nullable Cacheable input) {
        this.appendItem((byte)9, CacheKeyBuilder.cacheableToByteArray(input));
        return this;
    }

    public CacheKeyBuilder appendCacheables(Collection<? extends Cacheable> input) {
        this.appendItem((byte)10, CacheKeyBuilder.cacheableCollectionToByteArray(input, true));
        return this;
    }

    public CacheKeyBuilder appendCacheablesIgnoringOrder(Collection<? extends Cacheable> input) {
        this.appendItem((byte)10, CacheKeyBuilder.cacheableCollectionToByteArray(input, false));
        return this;
    }

    private void appendItem(byte typeKey, byte[] input) {
        Item item = new Item(typeKey, input);
        this.items.add(item);
        this.size += item.byteSize();
    }

    public byte[] build() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size);
        buffer.put(this.id);
        for (Item item : this.items) {
            buffer.put(item.typeKey).put(item.item);
        }
        return buffer.array();
    }

    private static class Item {
        private final byte typeKey;
        private final byte[] item;

        Item(byte typeKey, byte[] item) {
            this.typeKey = typeKey;
            this.item = item;
        }

        int byteSize() {
            return 1 + this.item.length;
        }
    }
}

