/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;

public class HyperUniqueExpressions {
    public static final ExpressionType TYPE = ExpressionType.fromColumnType(HyperUniquesAggregatorFactory.TYPE);

    public static class HllRoundEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "hyper_unique_round_estimate";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(final List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            class HllExpr
            extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
                public HllExpr(Expr arg) {
                    super(HllRoundEstimateExprMacro.NAME, arg);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)args.get(0)).eval(bindings);
                    if (!hllCollector.type().equals(TYPE)) {
                        throw HllRoundEstimateExprMacro.this.validationFailed("requires a hyper-log-log collector as input but got %s instead", hllCollector.type());
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    return ExprEval.ofLong(collector.estimateCardinalityRound());
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllRoundEstimateExprMacro.this.apply(shuttle.visitAll(args)));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }
            }
            return new HllExpr(args.get(0));
        }
    }

    public static class HllEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "hyper_unique_estimate";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(final List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            class HllExpr
            extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
                public HllExpr(Expr arg) {
                    super(HllEstimateExprMacro.NAME, arg);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)args.get(0)).eval(bindings);
                    if (!(TYPE.equals(hllCollector.type()) && hllCollector.type().is(ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector)) {
                        throw HllEstimateExprMacro.this.validationFailed("requires a hyper-log-log collector as input but got %s instead", hllCollector.type());
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    return ExprEval.ofDouble(collector.estimateCardinality());
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllEstimateExprMacro.this.apply(shuttle.visitAll(args)));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.DOUBLE;
                }
            }
            return new HllExpr(args.get(0));
        }
    }

    public static class HllAddExprMacro
    implements ExprMacroTable.ExprMacro {
        private static final String NAME = "hyper_unique_add";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 2);
            class HllExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public HllExpr(List<Expr> args) {
                    super(HllAddExprMacro.NAME, args);
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)this.args.get(1)).eval(bindings);
                    ExpressionType hllType = hllCollector.type();
                    if (!(TYPE.equals(hllType) && hllType.is(ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector)) {
                        throw HllAddExprMacro.this.validationFailed("requires a hyper-log-log collector as the second argument", new Object[0]);
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    switch ((ExprType)input.type().getType()) {
                        case STRING: {
                            if (input.value() == null) {
                                if (!NullHandling.replaceWithDefault()) break;
                                collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)"\u0000").asBytes());
                                break;
                            }
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)input.asString()).asBytes());
                            break;
                        }
                        case DOUBLE: {
                            if (!NullHandling.replaceWithDefault() && input.isNumericNull()) break;
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(Double.doubleToLongBits(input.asDouble())).asBytes());
                            break;
                        }
                        case LONG: {
                            if (!NullHandling.replaceWithDefault() && input.isNumericNull()) break;
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(input.asLong()).asBytes());
                            break;
                        }
                        case COMPLEX: {
                            if (TYPE.equals(input.type()) || hllType.is(ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector) {
                                collector.fold((HyperLogLogCollector)input.value());
                                break;
                            }
                        }
                        default: {
                            throw HllAddExprMacro.this.validationFailed("cannot add [%s] to hyper-log-log collector", input.type());
                        }
                    }
                    return ExprEval.ofComplex(TYPE, collector);
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllAddExprMacro.this.apply(shuttle.visitAll(this.args)));
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return TYPE;
                }
            }
            return new HllExpr(args);
        }
    }

    public static class HllCreateExprMacro
    implements ExprMacroTable.ExprMacro {
        private static final String NAME = "hyper_unique";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 0);
            final HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
            class HllExpression
            implements ExprMacroTable.ExprMacroFunctionExpr {
                HllExpression() {
                }

                @Override
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    return ExprEval.ofComplex(TYPE, collector);
                }

                @Override
                public String stringify() {
                    return StringUtils.format("%s()", HllCreateExprMacro.NAME);
                }

                @Override
                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(this);
                }

                @Override
                public Expr.BindingAnalysis analyzeInputs() {
                    return Expr.BindingAnalysis.EMTPY;
                }

                @Override
                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return TYPE;
                }

                @Override
                public List<Expr> getArgs() {
                    return Collections.emptyList();
                }

                public int hashCode() {
                    return Objects.hashCode(HllCreateExprMacro.NAME);
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    return obj != null && this.getClass() == obj.getClass();
                }

                public String toString() {
                    return StringUtils.format("(%s)", HllCreateExprMacro.NAME);
                }
            }
            return new HllExpression();
        }
    }
}

