/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class NullFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final String column;
    @Nullable
    private final FilterTuning filterTuning;

    public static NullFilter forColumn(String column) {
        return new NullFilter(column, null);
    }

    @JsonCreator
    public NullFilter(@JsonProperty(value="column") String column, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        if (column == null) {
            throw InvalidInput.exception("Invalid null filter, column cannot be null", new Object[0]);
        }
        this.column = column;
        this.filterTuning = filterTuning;
    }

    @JsonProperty
    public String getColumn() {
        return this.column;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(18).appendByte((byte)-1).appendString(this.column).build();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @Override
    @Nullable
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        TreeRangeSet retSet = TreeRangeSet.create();
        retSet.add(Range.lessThan((Comparable)((Object)"")));
        return retSet;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.column, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.column);
        if (indexSupplier == null) {
            return new AllTrueBitmapColumnIndex(selector);
        }
        NullValueIndex nullValueIndex = indexSupplier.as(NullValueIndex.class);
        if (nullValueIndex == null) {
            return null;
        }
        return nullValueIndex.get();
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.column, NullPredicateFactory.INSTANCE);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(NullPredicateFactory.INSTANCE);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.column, columnSelector, indexSelector);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.column);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.column);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, columnRewrites);
        }
        return new NullFilter(rewriteDimensionTo, this.filterTuning);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullFilter that = (NullFilter)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.filterTuning);
    }

    public String toString() {
        return new DimFilter.DimFilterToStringBuilder().appendDimension(this.column, null).append(" IS NULL").appendFilterTuning(this.filterTuning).build();
    }

    private static class NullPredicateFactory
    implements DruidPredicateFactory {
        public static final NullPredicateFactory INSTANCE = new NullPredicateFactory();

        private NullPredicateFactory() {
        }

        @Override
        public Predicate<String> makeStringPredicate() {
            return Predicates.isNull();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return DruidLongPredicate.MATCH_NULL_ONLY;
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return DruidFloatPredicate.MATCH_NULL_ONLY;
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return DruidDoublePredicate.MATCH_NULL_ONLY;
        }

        @Override
        public Predicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
            return Predicates.isNull();
        }

        @Override
        public Predicate<Object> makeObjectPredicate() {
            return Predicates.isNull();
        }

        @Override
        public boolean isNullInputUnknown() {
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass();
        }

        public String toString() {
            return "NullPredicateFactory{}";
        }
    }
}

