/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.DimensionHandlerUtils;

public class SelectorPredicateFactory
implements DruidPredicateFactory {
    @Nullable
    private final String value;
    private final Object initLock = new Object();
    private volatile DruidLongPredicate longPredicate;
    private volatile DruidFloatPredicate floatPredicate;
    private volatile DruidDoublePredicate doublePredicate;
    private final boolean isNullUnknown;

    public SelectorPredicateFactory(@Nullable String value) {
        this.value = value;
        this.isNullUnknown = value != null;
    }

    @Override
    public Predicate<String> makeStringPredicate() {
        return Predicates.equalTo((Object)this.value);
    }

    @Override
    public DruidLongPredicate makeLongPredicate() {
        this.initLongPredicate();
        return this.longPredicate;
    }

    @Override
    public DruidFloatPredicate makeFloatPredicate() {
        this.initFloatPredicate();
        return this.floatPredicate;
    }

    @Override
    public DruidDoublePredicate makeDoublePredicate() {
        this.initDoublePredicate();
        return this.doublePredicate;
    }

    @Override
    public boolean isNullInputUnknown() {
        return this.isNullUnknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLongPredicate() {
        if (this.longPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.longPredicate != null) {
                return;
            }
            if (this.value == null) {
                this.longPredicate = DruidLongPredicate.MATCH_NULL_ONLY;
                return;
            }
            Long valueAsLong = DimensionHandlerUtils.convertObjectToLong(this.value);
            if (valueAsLong == null) {
                this.longPredicate = DruidLongPredicate.ALWAYS_FALSE;
            } else {
                long unboxedLong = valueAsLong;
                this.longPredicate = input -> input == unboxedLong;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFloatPredicate() {
        if (this.floatPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.floatPredicate != null) {
                return;
            }
            if (this.value == null) {
                this.floatPredicate = DruidFloatPredicate.MATCH_NULL_ONLY;
                return;
            }
            Float valueAsFloat = DimensionHandlerUtils.convertObjectToFloat(this.value);
            if (valueAsFloat == null) {
                this.floatPredicate = DruidFloatPredicate.ALWAYS_FALSE;
            } else {
                int floatBits = Float.floatToIntBits(valueAsFloat.floatValue());
                this.floatPredicate = input -> Float.floatToIntBits(input) == floatBits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDoublePredicate() {
        if (this.doublePredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.doublePredicate != null) {
                return;
            }
            if (this.value == null) {
                this.doublePredicate = DruidDoublePredicate.MATCH_NULL_ONLY;
                return;
            }
            Double aDouble = DimensionHandlerUtils.convertObjectToDouble(this.value);
            if (aDouble == null) {
                this.doublePredicate = DruidDoublePredicate.ALWAYS_FALSE;
            } else {
                long bits = Double.doubleToLongBits(aDouble);
                this.doublePredicate = input -> Double.doubleToLongBits(input) == bits;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorPredicateFactory that = (SelectorPredicateFactory)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

