/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;

public class StringPredicateDruidPredicateFactory
implements DruidPredicateFactory {
    private final boolean isNullInputUnknown;
    @Nullable
    private final Predicate<String> predicate;

    public static StringPredicateDruidPredicateFactory equalTo(@Nullable String value) {
        return new StringPredicateDruidPredicateFactory((Predicate<String>)Predicates.equalTo((Object)value), value != null);
    }

    public static StringPredicateDruidPredicateFactory of(@Nullable Predicate<String> predicate, boolean isNullInputUnknown) {
        return new StringPredicateDruidPredicateFactory(predicate, isNullInputUnknown);
    }

    public StringPredicateDruidPredicateFactory(Predicate<String> predicate, boolean isNullInputUnknown) {
        this.predicate = predicate;
        this.isNullInputUnknown = isNullInputUnknown;
    }

    @Override
    public Predicate<String> makeStringPredicate() {
        return this.predicate;
    }

    @Override
    public DruidLongPredicate makeLongPredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    @Override
    public DruidFloatPredicate makeFloatPredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    @Override
    public DruidDoublePredicate makeDoublePredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    @Override
    public boolean isNullInputUnknown() {
        return this.isNullInputUnknown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringPredicateDruidPredicateFactory that = (StringPredicateDruidPredicateFactory)o;
        return this.isNullInputUnknown == that.isNullInputUnknown && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.isNullInputUnknown, this.predicate);
    }
}

