/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class WindowFrame {
    private final PeerType peerType;
    private final boolean lowerUnbounded;
    private final int lowerOffset;
    private final boolean upperUnbounded;
    private final int upperOffset;

    public static WindowFrame unbounded() {
        return new WindowFrame(PeerType.ROWS, true, 0, true, 0);
    }

    @JsonCreator
    public WindowFrame(@JsonProperty(value="peerType") PeerType peerType, @JsonProperty(value="lowUnbounded") boolean lowerUnbounded, @JsonProperty(value="lowOffset") int lowerOffset, @JsonProperty(value="uppUnbounded") boolean upperUnbounded, @JsonProperty(value="uppOffset") int upperOffset) {
        this.peerType = peerType;
        this.lowerUnbounded = lowerUnbounded;
        this.lowerOffset = lowerOffset;
        this.upperUnbounded = upperUnbounded;
        this.upperOffset = upperOffset;
    }

    @JsonProperty(value="peerType")
    public PeerType getPeerType() {
        return this.peerType;
    }

    @JsonProperty(value="lowUnbounded")
    public boolean isLowerUnbounded() {
        return this.lowerUnbounded;
    }

    @JsonProperty(value="lowOffset")
    public int getLowerOffset() {
        return this.lowerOffset;
    }

    @JsonProperty(value="uppUnbounded")
    public boolean isUpperUnbounded() {
        return this.upperUnbounded;
    }

    @JsonProperty(value="uppOffset")
    public int getUpperOffset() {
        return this.upperOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowFrame)) {
            return false;
        }
        WindowFrame that = (WindowFrame)o;
        return this.lowerUnbounded == that.lowerUnbounded && this.lowerOffset == that.lowerOffset && this.upperUnbounded == that.upperUnbounded && this.upperOffset == that.upperOffset && this.peerType == that.peerType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.peerType, this.lowerUnbounded, this.lowerOffset, this.upperUnbounded, this.upperOffset});
    }

    public String toString() {
        return "WindowFrame{peerType=" + (Object)((Object)this.peerType) + ", lowerUnbounded=" + this.lowerUnbounded + ", lowerOffset=" + this.lowerOffset + ", upperUnbounded=" + this.upperUnbounded + ", upperOffset=" + this.upperOffset + '}';
    }

    public static enum PeerType {
        ROWS,
        RANGE;

    }
}

