/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.QuerySegmentSpec;

public class DataSourceAnalysis {
    private final DataSource baseDataSource;
    @Nullable
    private final Query<?> baseQuery;
    @Nullable
    private final DimFilter joinBaseTableFilter;
    private final List<PreJoinableClause> preJoinableClauses;

    public DataSourceAnalysis(DataSource baseDataSource, @Nullable Query<?> baseQuery, @Nullable DimFilter joinBaseTableFilter, List<PreJoinableClause> preJoinableClauses) {
        if (baseDataSource instanceof JoinDataSource) {
            throw new IAE("Base dataSource cannot be a join! Original base datasource was: %s", baseDataSource);
        }
        this.baseDataSource = baseDataSource;
        this.baseQuery = baseQuery;
        this.joinBaseTableFilter = joinBaseTableFilter;
        this.preJoinableClauses = preJoinableClauses;
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public Optional<TableDataSource> getBaseTableDataSource() {
        if (this.baseDataSource instanceof TableDataSource) {
            return Optional.of((TableDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<UnionDataSource> getBaseUnionDataSource() {
        if (this.baseDataSource instanceof UnionDataSource) {
            return Optional.of((UnionDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<Query<?>> getBaseQuery() {
        return Optional.ofNullable(this.baseQuery);
    }

    public Optional<DimFilter> getJoinBaseTableFilter() {
        return Optional.ofNullable(this.joinBaseTableFilter);
    }

    public Optional<QuerySegmentSpec> getBaseQuerySegmentSpec() {
        return this.getBaseQuery().map(query -> ((BaseQuery)query).getQuerySegmentSpec());
    }

    public DataSourceAnalysis maybeWithBaseQuery(Query<?> query) {
        if (!this.getBaseQuery().isPresent()) {
            return new DataSourceAnalysis(this.baseDataSource, query, this.joinBaseTableFilter, this.preJoinableClauses);
        }
        return this;
    }

    public List<PreJoinableClause> getPreJoinableClauses() {
        return this.preJoinableClauses;
    }

    public boolean isConcreteBased() {
        return this.baseDataSource.isConcrete() && this.preJoinableClauses.stream().allMatch(clause -> clause.getDataSource().isGlobal());
    }

    public boolean isTableBased() {
        return this.baseDataSource instanceof TableDataSource || this.baseDataSource instanceof UnionDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource) || this.baseDataSource instanceof UnnestDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource);
    }

    public boolean isConcreteAndTableBased() {
        return this.isConcreteBased() && this.isTableBased();
    }

    public boolean isJoin() {
        return !this.preJoinableClauses.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceAnalysis that = (DataSourceAnalysis)o;
        return Objects.equals(this.baseDataSource, that.baseDataSource);
    }

    public int hashCode() {
        return Objects.hash(this.baseDataSource);
    }

    public String toString() {
        return "DataSourceAnalysis{, baseDataSource=" + this.baseDataSource + ", baseQuery=" + this.baseQuery + ", preJoinableClauses=" + this.preJoinableClauses + '}';
    }
}

