/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentResultValue;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultGranularTimestampComparator;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.topn.BySegmentTopNResultValue;
import org.apache.druid.query.topn.DefaultTopNQueryMetricsFactory;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNBinaryFn;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryEngine;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNQueryMetricsFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.DateTime;

public class TopNQueryQueryToolChest
extends QueryToolChest<Result<TopNResultValue>, TopNQuery> {
    private static final byte TOPN_QUERY = 1;
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final TopNQueryConfig config;
    private final TopNQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TopNQueryQueryToolChest(TopNQueryConfig config) {
        this(config, DefaultTopNQueryMetricsFactory.instance());
    }

    @Inject
    public TopNQueryQueryToolChest(TopNQueryConfig config, TopNQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    protected static String[] extractFactoryName(List<AggregatorFactory> aggregatorFactories) {
        return (String[])aggregatorFactories.stream().map(AggregatorFactory::getName).toArray(String[]::new);
    }

    private static List<PostAggregator> prunePostAggregators(TopNQuery query) {
        return AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeResults(QueryRunner<Result<TopNResultValue>> runner) {
        ResultMergeQueryRunner<Result<TopNResultValue>> delegateRunner = new ResultMergeQueryRunner<Result<TopNResultValue>>(runner, query -> ResultGranularTimestampComparator.create(query.getGranularity(), query.isDescending()), query -> {
            TopNQuery topNQuery = (TopNQuery)query;
            return new TopNBinaryFn(topNQuery.getGranularity(), topNQuery.getDimensionSpec(), topNQuery.getTopNMetricSpec(), topNQuery.getThreshold(), topNQuery.getAggregatorSpecs(), topNQuery.getPostAggregatorSpecs());
        });
        return (queryPlus, responseContext) -> {
            TopNQuery query = (TopNQuery)queryPlus.getQuery();
            List<PostAggregator> prunedPostAggs = TopNQueryQueryToolChest.prunePostAggregators(query);
            return delegateRunner.run(queryPlus.withQuery(query.withPostAggregatorSpecs(prunedPostAggs)), responseContext).map(result -> {
                List<PostAggregator> postAggs = query.getPostAggregatorSpecs();
                if (query.context().isBySegment()) {
                    BySegmentResultValue bySeg = (BySegmentResultValue)result.getValue();
                    List results = bySeg.getResults();
                    ArrayList<Result<TopNResultValue>> resultValues = new ArrayList<Result<TopNResultValue>>(results.size());
                    for (Result bySegResult : results) {
                        resultValues.add(this.resultWithPostAggs(postAggs, bySegResult));
                    }
                    return new Result<BySegmentTopNResultValue>(result.getTimestamp(), new BySegmentTopNResultValue(resultValues, bySeg.getSegmentId(), bySeg.getInterval()));
                }
                return this.resultWithPostAggs(postAggs, (Result<TopNResultValue>)result);
            });
        };
    }

    public TopNQueryMetrics makeMetrics(TopNQuery query) {
        TopNQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePreComputeManipulatorFn(final TopNQuery query, MetricManipulationFn fn) {
        if (MetricManipulatorFns.deserializing() != fn) {
            throw DruidException.defensive("This method can only be used to deserialize.", new Object[0]);
        }
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            {
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                List<DimensionAndMetricValueExtractor> values = result.getValue().getValue();
                ArrayList<DimensionAndMetricValueExtractor> newValues = new ArrayList<DimensionAndMetricValueExtractor>(values.size());
                for (DimensionAndMetricValueExtractor input : values) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(input.getBaseObject());
                    for (int i = 0; i < this.aggregatorFactories.length; ++i) {
                        String aggName = this.aggFactoryNames[i];
                        map.put(aggName, this.aggregatorFactories[i].deserialize(map.get(aggName)));
                    }
                    newValues.add(new DimensionAndMetricValueExtractor(map));
                }
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(newValues));
            }
        };
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePostComputeManipulatorFn(final TopNQuery query, MetricManipulationFn fn) {
        if (MetricManipulatorFns.identity() == fn) {
            return result -> result;
        }
        if (MetricManipulatorFns.finalizing() == fn) {
            return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
                private final AggregatorFactory[] aggregatorFactories;
                private final String[] aggFactoryNames;
                {
                    this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                    this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                }

                public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                    List<DimensionAndMetricValueExtractor> values = result.getValue().getValue();
                    ArrayList<DimensionAndMetricValueExtractor> newValues = new ArrayList<DimensionAndMetricValueExtractor>(values.size());
                    for (DimensionAndMetricValueExtractor input : values) {
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(input.getBaseObject());
                        for (int i = 0; i < this.aggregatorFactories.length; ++i) {
                            String aggName = this.aggFactoryNames[i];
                            map.put(aggName, this.aggregatorFactories[i].finalizeComputation(map.get(aggName)));
                        }
                        newValues.add(new DimensionAndMetricValueExtractor(map));
                    }
                    return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(newValues));
                }
            };
        }
        throw DruidException.defensive("This method can only be used to finalize.", new Object[0]);
    }

    @Override
    public TypeReference<Result<TopNResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TopNResultValue>, Object, TopNQuery> getCacheStrategy(final TopNQuery query) {
        return new CacheStrategy<Result<TopNResultValue>, Object, TopNQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = Lists.newArrayList(query.getAggregatorSpecs());
                this.postAggs = AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
            }

            @Override
            public boolean isCacheable(TopNQuery query2, boolean willMergeRunners, boolean bySegment) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TopNQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(1).appendCacheable(query2.getDimensionSpec()).appendCacheable(query2.getTopNMetricSpec()).appendInt(query2.getThreshold()).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns());
                List postAggregators = TopNQueryQueryToolChest.prunePostAggregators(query2);
                if (!postAggregators.isEmpty()) {
                    builder.appendCacheablesIgnoringOrder(postAggregators);
                }
                return builder.build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(TopNQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(1).appendCacheable(query2.getDimensionSpec()).appendCacheable(query2.getTopNMetricSpec()).appendInt(query2.getThreshold()).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimensionsFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheable(query2.getVirtualColumns()).appendCacheables(query2.getPostAggregatorSpecs());
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TopNResultValue>, Object> prepareForCache(final boolean isResultLevelCache) {
                return new Function<Result<TopNResultValue>, Object>(){
                    private final String[] aggFactoryNames;
                    {
                        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                    }

                    public Object apply(Result<TopNResultValue> input) {
                        ArrayList results = Lists.newArrayList((Iterable)input.getValue());
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(results.size() + 1));
                        retVal.add(input.getTimestamp().getMillis());
                        for (DimensionAndMetricValueExtractor result : results) {
                            ArrayList vals = Lists.newArrayListWithCapacity((int)(this.aggFactoryNames.length + 2));
                            vals.add(result.getDimensionValue(query.getDimensionSpec().getOutputName()));
                            for (String aggName : this.aggFactoryNames) {
                                vals.add(result.getMetric(aggName));
                            }
                            if (isResultLevelCache) {
                                for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                                    vals.add(result.getMetric(postAgg.getName()));
                                }
                            }
                            retVal.add(vals);
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TopNResultValue>> pullFromCache(final boolean isResultLevelCache) {
                return new Function<Object, Result<TopNResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TopNResultValue> apply(Object input) {
                        List results = (List)input;
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)results.size());
                        Iterator inputIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)inputIter.next()).longValue());
                        while (inputIter.hasNext()) {
                            List result = (List)inputIter.next();
                            LinkedHashMap vals = Maps.newLinkedHashMap();
                            Iterator<Object> resultIter = result.iterator();
                            vals.put(query.getDimensionSpec().getOutputName(), DimensionHandlerUtils.convertObjectToType(resultIter.next(), query.getDimensionSpec().getOutputType()));
                            CacheStrategy.fetchAggregatorsFromCache(aggs, resultIter, isResultLevelCache, (aggName, aggPos, aggValueObject) -> vals.put(aggName, aggValueObject));
                            if (isResultLevelCache) {
                                Iterator<PostAggregator> postItr = query.getPostAggregatorSpecs().iterator();
                                while (postItr.hasNext() && resultIter.hasNext()) {
                                    vals.put(postItr.next().getName(), resultIter.next());
                                }
                            } else {
                                for (PostAggregator postAgg : postAggs) {
                                    vals.put(postAgg.getName(), postAgg.compute(vals));
                                }
                            }
                            retVal.add(vals);
                        }
                        return new Result<TopNResultValue>(timestamp, TopNResultValue.create(retVal));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> preMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        return (queryPlus, responseContext) -> {
            TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
            if (TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                DimensionSpec dimensionSpec = topNQuery.getDimensionSpec();
                QueryPlus<Result<TopNResultValue>> delegateQueryPlus = queryPlus.withQuery(topNQuery.withDimensionSpec(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName())));
                return runner.run(delegateQueryPlus, responseContext);
            }
            return runner.run(queryPlus.withQuery(topNQuery), responseContext);
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> postMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        final ThresholdAdjustingQueryRunner thresholdRunner = new ThresholdAdjustingQueryRunner(runner, this.config);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, ResponseContext responseContext) {
                Sequence<Result<TopNResultValue>> resultSequence = thresholdRunner.run(queryPlus, responseContext);
                final TopNQuery topNQuery = (TopNQuery)queryPlus.getQuery();
                if (!TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                    return resultSequence;
                }
                return Sequences.map(resultSequence, new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                    public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                        TopNResultValue resultValue = input.getValue();
                        return new Result<TopNResultValue>(input.getTimestamp(), TopNResultValue.create(Lists.transform(resultValue.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, DimensionAndMetricValueExtractor>(){

                            public DimensionAndMetricValueExtractor apply(DimensionAndMetricValueExtractor input) {
                                String dimOutputName = topNQuery.getDimensionSpec().getOutputName();
                                Object dimValue = input.getDimensionValue(dimOutputName);
                                Map<String, Object> map = input.getBaseObject();
                                map.put(dimOutputName, topNQuery.getDimensionSpec().getExtractionFn().apply(dimValue));
                                return input;
                            }
                        })));
                    }
                });
            }
        };
    }

    @Override
    public RowSignature resultArraySignature(TopNQuery query) {
        return RowSignature.builder().addTimeColumn().addDimensions(Collections.singletonList(query.getDimensionSpec())).addAggregators(query.getAggregatorSpecs(), RowSignature.Finalization.UNKNOWN).addPostAggregators(query.getPostAggregatorSpecs()).build();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(TopNQuery query, Sequence<Result<TopNResultValue>> resultSequence) {
        List<String> fields = this.resultArraySignature(query).getColumnNames();
        return resultSequence.flatMap(result -> {
            List<DimensionAndMetricValueExtractor> rows = ((TopNResultValue)result.getValue()).getValue();
            return Sequences.simple(Iterables.transform(rows, row -> {
                Object[] retVal = new Object[fields.size()];
                retVal[0] = result.getTimestamp().getMillis();
                Map<String, Object> resultMap = row.getBaseObject();
                for (int i = 1; i < fields.size(); ++i) {
                    retVal[i] = resultMap.get(fields.get(i));
                }
                return retVal;
            }));
        });
    }

    @Override
    public Optional<Sequence<FrameSignaturePair>> resultsAsFrames(TopNQuery query, Sequence<Result<TopNResultValue>> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes) {
        RowSignature rowSignature = this.resultArraySignature(query);
        Pair<Cursor, Closeable> cursorAndCloseable = IterableRowsCursorHelper.getCursorFromSequence(this.resultsAsArrays(query, resultSequence), rowSignature);
        Cursor cursor = (Cursor)cursorAndCloseable.lhs;
        Closeable closeable = (Closeable)cursorAndCloseable.rhs;
        RowSignature modifiedRowSignature = useNestedForUnknownTypes ? FrameWriterUtils.replaceUnknownTypesWithNestedColumns(rowSignature) : rowSignature;
        FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory(FrameType.COLUMNAR, memoryAllocatorFactory, rowSignature, new ArrayList<KeyColumn>());
        Sequence<Frame> frames = FrameCursorUtils.cursorToFrames(cursor, frameWriterFactory).withBaggage(closeable);
        return Optional.of(frames.map(frame -> new FrameSignaturePair((Frame)frame, modifiedRowSignature)));
    }

    private Result<TopNResultValue> resultWithPostAggs(List<PostAggregator> postAggs, Result<TopNResultValue> result) {
        List<DimensionAndMetricValueExtractor> values = result.getValue().getValue();
        ArrayList<DimensionAndMetricValueExtractor> newValues = new ArrayList<DimensionAndMetricValueExtractor>(values.size());
        for (DimensionAndMetricValueExtractor input : values) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(input.getBaseObject());
            for (PostAggregator postAgg : postAggs) {
                map.put(postAgg.getName(), postAgg.compute(map));
            }
            newValues.add(new DimensionAndMetricValueExtractor(map));
        }
        return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(newValues));
    }

    static class ThresholdAdjustingQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        private final TopNQueryConfig config;

        public ThresholdAdjustingQueryRunner(QueryRunner<Result<TopNResultValue>> runner, TopNQueryConfig config) {
            this.runner = runner;
            this.config = config;
        }

        @Override
        public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TopNResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TopNQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", TopNQuery.class, input.getClass());
            }
            final TopNQuery query = (TopNQuery)input;
            int minTopNThreshold = query.context().getInt("minTopNThreshold", this.config.getMinTopNThreshold());
            if (query.getThreshold() > minTopNThreshold) {
                return this.runner.run(queryPlus, responseContext);
            }
            final boolean isBySegment = query.context().isBySegment();
            return Sequences.map(this.runner.run(queryPlus.withQuery(query.withThreshold(minTopNThreshold)), responseContext), new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                    if (isBySegment) {
                        BySegmentResultValue value = (BySegmentResultValue)((Object)input.getValue());
                        return new Result<TopNResultValue>(input.getTimestamp(), new BySegmentTopNResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                            public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                                return new Result<TopNResultValue>(input.getTimestamp(), TopNResultValue.create(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<TopNResultValue>(input.getTimestamp(), TopNResultValue.create(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                }
            });
        }
    }
}

