/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.utils.CollectionUtils;

public class ConstantMultiValueDimensionSelector
implements HistoricalDimensionSelector {
    private final List<String> values;
    private final RangeIndexedInts row;

    public ConstantMultiValueDimensionSelector(List<String> values) {
        if (CollectionUtils.isNullOrEmpty(values)) {
            throw DruidException.defensive("Use DimensionSelector.constant(null)", new Object[0]);
        }
        this.values = values;
        this.row = new RangeIndexedInts();
        this.row.setSize(values.size());
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("values", this.values);
        inspector.visit("row", this.row);
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.values.get(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    public IndexedInts getRow() {
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return this.values.stream().anyMatch(v -> Objects.equals(value, v)) ? ValueMatchers.allTrue() : ValueMatchers.allFalse();
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        return this.values.stream().anyMatch(arg_0 -> predicate.apply(arg_0)) ? ValueMatchers.allTrue() : ValueMatchers.allFalse();
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.row;
    }
}

