/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.BitSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;

public final class DimensionSelectorUtils {
    private DimensionSelectorUtils() {
    }

    public static ValueMatcher makeValueMatcherGeneric(DimensionSelector selector, @Nullable String value) {
        IdLookup idLookup = selector.idLookup();
        if (idLookup != null) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, idLookup.lookupId(value), value == null);
        }
        if (selector.getValueCardinality() >= 0 && selector.nameLookupPossibleInAdvance()) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, StringPredicateDruidPredicateFactory.equalTo(value));
        }
        return DimensionSelectorUtils.makeNonDictionaryEncodedValueMatcherGeneric(selector, value);
    }

    private static ValueMatcher makeDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final int valueId, final boolean matchNull) {
        if (valueId >= 0) {
            return new ValueMatcher(){

                @Override
                public boolean matches(boolean includeUnknown) {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    if (size == 0) {
                        return includeUnknown || matchNull;
                    }
                    for (int i = 0; i < size; ++i) {
                        int rowId = row.get(i);
                        if ((!includeUnknown || selector.lookupName(rowId) != null) && rowId != valueId) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("selector", selector);
                }
            };
        }
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                if (includeUnknown || matchNull) {
                    IndexedInts row = selector.getRow();
                    int size = row.size();
                    if (size == 0) {
                        return true;
                    }
                    boolean nullRow = true;
                    for (int i = 0; i < size; ++i) {
                        String rowValue = selector.lookupName(row.get(i));
                        if (rowValue == null) {
                            return true;
                        }
                        nullRow = false;
                    }
                    return nullRow;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    private static ValueMatcher makeNonDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final @Nullable String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return includeUnknown || value == null;
                }
                for (int i = 0; i < size; ++i) {
                    String rowValue = selector.lookupName(row.get(i));
                    if ((!includeUnknown || rowValue != null) && !Objects.equals(rowValue, value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeValueMatcherGeneric(DimensionSelector selector, DruidPredicateFactory predicateFactory) {
        int cardinality = selector.getValueCardinality();
        if (cardinality >= 0 && selector.nameLookupPossibleInAdvance()) {
            return DimensionSelectorUtils.makeDictionaryEncodedValueMatcherGeneric(selector, predicateFactory);
        }
        return DimensionSelectorUtils.makeNonDictionaryEncodedValueMatcherGeneric(selector, predicateFactory);
    }

    private static ValueMatcher makeDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final DruidPredicateFactory predicateFactory) {
        final BitSet checkedIds = new BitSet(selector.getValueCardinality());
        final BitSet matchingIds = new BitSet(selector.getValueCardinality());
        final Predicate<String> predicate = predicateFactory.makeStringPredicate();
        final boolean predicateMatchesNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                boolean matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return matchNull || predicateMatchesNull;
                }
                for (int i = 0; i < size; ++i) {
                    boolean matches;
                    int id = row.get(i);
                    if (checkedIds.get(id)) {
                        matches = matchingIds.get(id);
                    } else {
                        String rowValue = selector.lookupName(id);
                        matches = matchNull && rowValue == null || predicate.apply((Object)rowValue);
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                    }
                    if (!matches) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    private static ValueMatcher makeNonDictionaryEncodedValueMatcherGeneric(final DimensionSelector selector, final DruidPredicateFactory predicateFactory) {
        final Predicate<String> predicate = predicateFactory.makeStringPredicate();
        final boolean predicateMatchesNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                boolean matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return matchNull || predicateMatchesNull;
                }
                for (int i = 0; i < size; ++i) {
                    String rowValue = selector.lookupName(row.get(i));
                    if ((!matchNull || rowValue != null) && !predicate.apply((Object)rowValue)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static BitSet makePredicateMatchingSet(DimensionSelector selector, Predicate<String> predicate) {
        if (!selector.nameLookupPossibleInAdvance()) {
            throw new IAE("selector.nameLookupPossibleInAdvance() should return true", new Object[0]);
        }
        int cardinality = selector.getValueCardinality();
        BitSet valueIds = new BitSet(cardinality);
        for (int i = 0; i < cardinality; ++i) {
            if (!predicate.apply((Object)selector.lookupName(i))) continue;
            valueIds.set(i);
        }
        return valueIds;
    }
}

