/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.io.ZeroCopyByteArrayOutputStream;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.DoubleColumnSerializer;
import org.apache.druid.segment.DoubleColumnSerializerV2;
import org.apache.druid.segment.FloatColumnSerializer;
import org.apache.druid.segment.FloatColumnSerializerV2;
import org.apache.druid.segment.ForwardingRowIterator;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.LongColumnSerializer;
import org.apache.druid.segment.LongColumnSerializerV2;
import org.apache.druid.segment.MergingRowIterator;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowCombiningTimeAndDimsIterator;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TimeAndDimsIterator;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.serde.DoubleNumericColumnPartSerde;
import org.apache.druid.segment.serde.DoubleNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.FloatNumericColumnPartSerde;
import org.apache.druid.segment.serde.FloatNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.LongNumericColumnPartSerde;
import org.apache.druid.segment.serde.LongNumericColumnPartSerdeV2;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
implements IndexMerger {
    private static final Logger log = new Logger(IndexMergerV9.class);
    private final ObjectMapper mapper;
    private final IndexIO indexIO;
    private final SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory;
    private final boolean storeEmptyColumns;

    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory, boolean storeEmptyColumns) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.defaultSegmentWriteOutMediumFactory = (SegmentWriteOutMediumFactory)Preconditions.checkNotNull((Object)defaultSegmentWriteOutMediumFactory, (Object)"null SegmentWriteOutMediumFactory");
        this.storeEmptyColumns = storeEmptyColumns;
    }

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        this(mapper, indexIO, defaultSegmentWriteOutMediumFactory, false);
    }

    private File makeIndexFiles(List<IndexableAdapter> adapters, @Nullable AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, DimensionsSpecInspector dimensionsSpecInspector, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, boolean fillRowNumConversions, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        Metadata segmentMetadata;
        progress.start();
        progress.progress();
        List metadataList = Lists.transform(adapters, IndexableAdapter::getMetadata);
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        try (Closer closer = Closer.create();){
            FileSmoosher v9Smoosher = new FileSmoosher(outDir);
            FileUtils.mkdirp(outDir);
            SegmentWriteOutMediumFactory omf = segmentWriteOutMediumFactory != null ? segmentWriteOutMediumFactory : this.defaultSegmentWriteOutMediumFactory;
            log.debug("Using SegmentWriteOutMediumFactory[%s]", omf.getClass().getSimpleName());
            SegmentWriteOutMedium segmentWriteOutMedium = omf.makeSegmentWriteOutMedium(outDir);
            closer.register(segmentWriteOutMedium);
            long startTime = System.currentTimeMillis();
            Files.asByteSink((File)new File(outDir, "version.bin"), (FileWriteMode[])new FileWriteMode[0]).write(Ints.toByteArray((int)9));
            log.debug("Completed version.bin in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            startTime = System.currentTimeMillis();
            try (FileOutputStream fos = new FileOutputStream(new File(outDir, "factory.json"));){
                SegmentizerFactory customSegmentLoader = indexSpec.getSegmentLoader();
                if (customSegmentLoader != null) {
                    this.mapper.writeValue((OutputStream)fos, (Object)customSegmentLoader);
                } else {
                    this.mapper.writeValue((OutputStream)fos, (Object)new MMappedQueryableSegmentizerFactory(this.indexIO));
                }
            }
            log.debug("Completed factory.json in %,d millis", System.currentTimeMillis() - startTime);
            progress.progress();
            TreeMap<String, ColumnFormat> metricFormats = new TreeMap<String, ColumnFormat>((Comparator<String>)Comparators.naturalNullsFirst());
            ArrayList dimFormats = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.mergeFormat(adapters, mergedDimensions, metricFormats, dimFormats);
            Map<String, DimensionHandler> handlers = this.makeDimensionHandlers(mergedDimensions, dimFormats);
            ArrayList<DimensionMergerV9> mergers = new ArrayList<DimensionMergerV9>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionHandler handler = handlers.get(mergedDimensions.get(i));
                mergers.add(handler.makeMerger(indexSpec, segmentWriteOutMedium, ((ColumnFormat)dimFormats.get(i)).toColumnCapabilities(), progress, closer));
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            this.writeDimValuesAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.debug("Completed dim conversions in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            TimeAndDimsIterator timeAndDimsIterator = this.makeMergedTimeAndDimsIterator(adapters, mergedDimensions, mergedMetrics, rowMergerFn, handlers, mergers);
            closer.register(timeAndDimsIterator);
            GenericColumnSerializer timeWriter = this.setupTimeWriter(segmentWriteOutMedium, indexSpec);
            ArrayList<GenericColumnSerializer> metricWriters = this.setupMetricsWriters(segmentWriteOutMedium, mergedMetrics, metricFormats, indexSpec);
            IndexMergeResult indexMergeResult = this.mergeIndexesAndWriteColumns(adapters, progress, timeAndDimsIterator, timeWriter, metricWriters, mergers, fillRowNumConversions);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v9Smoosher, progress, timeWriter, indexSpec);
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricFormats, metricWriters, indexSpec);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                ColumnDescriptor columnDesc;
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(indexMergeResult.rowNumConversions);
                if (!merger.hasOnlyNulls()) {
                    columnDesc = merger.makeColumnDescriptor();
                    this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
                    continue;
                }
                if (!dimensionsSpecInspector.shouldStore(mergedDimensions.get(i))) continue;
                columnDesc = ColumnDescriptor.builder().setValueType((ValueType)((ColumnFormat)dimFormats.get(i)).getLogicalType().getType()).addSerde(new NullColumnPartSerde(indexMergeResult.rowCount, indexSpec.getBitmapSerdeFactory())).build();
                this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, progress, indexSpec, mergers, dimensionsSpecInspector);
            this.makeMetadataBinary(v9Smoosher, progress, segmentMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes((Object)segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec, List<DimensionMergerV9> mergers, DimensionsSpecInspector dimensionsSpecInspector) throws IOException {
        HashSet<String> columnSet = new HashSet<String>(mergedDimensions);
        columnSet.addAll(mergedMetrics);
        Preconditions.checkState((columnSet.size() == mergedDimensions.size() + mergedMetrics.size() ? 1 : 0) != 0, (String)"column names are not unique in dims%s and mets%s", mergedDimensions, mergedMetrics);
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        ArrayList<String> nonNullOnlyDimensions = new ArrayList<String>(mergedDimensions.size());
        ArrayList<String> nonNullOnlyColumns = new ArrayList<String>(mergedDimensions.size() + mergedMetrics.size());
        nonNullOnlyColumns.addAll(mergedMetrics);
        ArrayList<String> allDimensions = new ArrayList<String>(mergedDimensions.size());
        ArrayList<String> allColumns = new ArrayList<String>(mergedDimensions.size() + mergedMetrics.size());
        IntStream.range(0, mergedMetrics.size()).forEach(i -> allColumns.add(null));
        for (int i2 = 0; i2 < mergedDimensions.size(); ++i2) {
            if (!mergers.get(i2).hasOnlyNulls()) {
                nonNullOnlyDimensions.add(mergedDimensions.get(i2));
                nonNullOnlyColumns.add(mergedDimensions.get(i2));
                allDimensions.add(null);
                allColumns.add(null);
                continue;
            }
            if (!dimensionsSpecInspector.shouldStore(mergedDimensions.get(i2))) continue;
            allDimensions.add(mergedDimensions.get(i2));
            allColumns.add(mergedDimensions.get(i2));
        }
        GenericIndexed<String> nonNullCols = GenericIndexed.fromIterable(nonNullOnlyColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nonNullDims = GenericIndexed.fromIterable(nonNullOnlyDimensions, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nullCols = GenericIndexed.fromIterable(allColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> nullDims = GenericIndexed.fromIterable(allDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory());
        long numBytes = nonNullCols.getSerializedSize() + nonNullDims.getSerializedSize() + nullCols.getSerializedSize() + nullDims.getSerializedSize() + 16L + (long)SERIALIZER_UTILS.getSerializedStringByteSize(bitmapSerdeFactoryType);
        try (SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);){
            nonNullCols.writeTo(writer, v9Smoosher);
            nonNullDims.writeTo(writer, v9Smoosher);
            DateTime minTime = DateTimes.MAX;
            DateTime maxTime = DateTimes.MIN;
            for (IndexableAdapter index : adapters) {
                minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
                maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
            }
            Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
            SERIALIZER_UTILS.writeLong(writer, dataInterval.getStartMillis());
            SERIALIZER_UTILS.writeLong(writer, dataInterval.getEndMillis());
            SERIALIZER_UTILS.writeString(writer, bitmapSerdeFactoryType);
            nullCols.writeTo(writer, v9Smoosher);
            nullDims.writeTo(writer, v9Smoosher);
        }
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.debug("Completed index.drd in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make index.drd");
    }

    private void makeMetricsColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ColumnFormat> metricsTypes, List<GenericColumnSerializer> metWriters, IndexSpec indexSpec) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ColumnType type = metricsTypes.get(metric).getLogicalType();
            switch ((ValueType)type.getType()) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(IndexMergerV9.createLongColumnPartSerde(writer, indexSpec));
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(IndexMergerV9.createFloatColumnPartSerde(writer, indexSpec));
                    break;
                }
                case DOUBLE: {
                    builder.setValueType(ValueType.DOUBLE);
                    builder.addSerde(IndexMergerV9.createDoubleColumnPartSerde(writer, indexSpec));
                    break;
                }
                case COMPLEX: {
                    String typeName = type.getComplexTypeName();
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate(writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", type);
                }
            }
            this.makeColumn(v9Smoosher, metric, builder.build());
            log.debug("Completed metric column[%s] in %,d millis.", metric, System.currentTimeMillis() - metricStartTime);
        }
        log.debug("Completed metric columns in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make metric columns");
    }

    static ColumnPartSerde createLongColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return LongNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return LongNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createDoubleColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return DoubleNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return DoubleNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    static ColumnPartSerde createFloatColumnPartSerde(GenericColumnSerializer serializer, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return FloatNumericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(serializer).build();
        }
        return FloatNumericColumnPartSerdeV2.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withBitmapSerdeFactory(indexSpec.getBitmapSerdeFactory()).withDelegate(serializer).build();
    }

    private void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, GenericColumnSerializer timeWriter, IndexSpec indexSpec) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(IndexMergerV9.createLongColumnPartSerde(timeWriter, indexSpec)).build();
        this.makeColumn(v9Smoosher, "__time", serdeficator);
        log.debug("Completed time column in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make time column");
    }

    private void makeColumn(FileSmoosher v9Smoosher, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ZeroCopyByteArrayOutputStream specBytes = new ZeroCopyByteArrayOutputStream();
        SERIALIZER_UTILS.writeString(specBytes, this.mapper.writeValueAsString((Object)serdeficator));
        try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(columnName, (long)specBytes.size() + serdeficator.getSerializedSize());){
            specBytes.writeTo(channel);
            serdeficator.writeTo(channel, v9Smoosher);
        }
    }

    private IndexMergeResult mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, TimeAndDimsIterator timeAndDimsIterator, GenericColumnSerializer timeWriter, ArrayList<GenericColumnSerializer> metricWriters, List<DimensionMergerV9> mergers, boolean fillRowNumConversions) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        ArrayList<IntBuffer> rowNumConversions = null;
        int rowCount = 0;
        if (fillRowNumConversions) {
            rowNumConversions = new ArrayList<IntBuffer>(adapters.size());
            for (IndexableAdapter adapter : adapters) {
                int[] arr = new int[adapter.getNumRows()];
                Arrays.fill(arr, -1);
                rowNumConversions.add(IntBuffer.wrap(arr));
            }
        }
        long time = System.currentTimeMillis();
        while (timeAndDimsIterator.moveToNext()) {
            progress.progress();
            TimeAndDimsPointer timeAndDims = timeAndDimsIterator.getPointer();
            timeWriter.serialize(timeAndDims.timestampSelector);
            for (int metricIndex = 0; metricIndex < timeAndDims.getNumMetrics(); ++metricIndex) {
                metricWriters.get(metricIndex).serialize(timeAndDims.getMetricSelector(metricIndex));
            }
            for (int dimIndex = 0; dimIndex < timeAndDims.getNumDimensions(); ++dimIndex) {
                DimensionMergerV9 merger = mergers.get(dimIndex);
                if (merger.hasOnlyNulls()) continue;
                merger.processMergedRow(timeAndDims.getDimensionSelector(dimIndex));
            }
            if (timeAndDimsIterator instanceof RowCombiningTimeAndDimsIterator) {
                RowCombiningTimeAndDimsIterator comprisedRows = (RowCombiningTimeAndDimsIterator)timeAndDimsIterator;
                int originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(0);
                while (originalIteratorIndex >= 0) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(originalIteratorIndex);
                    int minRowNum = comprisedRows.getMinCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    int maxRowNum = comprisedRows.getMaxCurrentlyCombinedRowNumByOriginalIteratorIndex(originalIteratorIndex);
                    for (int rowNum = minRowNum; rowNum <= maxRowNum; ++rowNum) {
                        while (conversionBuffer.position() < rowNum) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                    originalIteratorIndex = comprisedRows.nextCurrentlyCombinedOriginalIteratorIndex(originalIteratorIndex + 1);
                }
            } else if (timeAndDimsIterator instanceof MergingRowIterator) {
                RowPointer rowPointer = (RowPointer)timeAndDims;
                IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(rowPointer.getIndexNum());
                int rowNum = rowPointer.getRowNum();
                while (conversionBuffer.position() < rowNum) {
                    conversionBuffer.put(-1);
                }
                conversionBuffer.put(rowCount);
            } else if (fillRowNumConversions) {
                throw new IllegalStateException("Filling row num conversions is supported only with RowCombining and Merging iterators");
            }
            if (++rowCount % 500000 != 0) continue;
            log.debug("walked 500,000/%d rows in %,d millis.", rowCount, System.currentTimeMillis() - time);
            time = System.currentTimeMillis();
        }
        if (rowNumConversions != null) {
            for (IntBuffer rowNumConversion : rowNumConversions) {
                rowNumConversion.rewind();
            }
        }
        log.debug("completed walk through of %,d rows in %,d millis.", rowCount, System.currentTimeMillis() - startTime);
        progress.stopSection("walk through and merge rows");
        return new IndexMergeResult(rowNumConversions, rowCount);
    }

    private GenericColumnSerializer setupTimeWriter(SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec) throws IOException {
        GenericColumnSerializer timeWriter = IndexMergerV9.createLongColumnSerializer(segmentWriteOutMedium, "little_end_time", indexSpec);
        timeWriter.open();
        return timeWriter;
    }

    private ArrayList<GenericColumnSerializer> setupMetricsWriters(SegmentWriteOutMedium segmentWriteOutMedium, List<String> mergedMetrics, Map<String, ColumnFormat> metricsTypes, IndexSpec indexSpec) throws IOException {
        ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ColumnType type = metricsTypes.get(metric).getLogicalType();
            switch ((ValueType)type.getType()) {
                case LONG: {
                    writer = IndexMergerV9.createLongColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case FLOAT: {
                    writer = IndexMergerV9.createFloatColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case DOUBLE: {
                    writer = IndexMergerV9.createDoubleColumnSerializer(segmentWriteOutMedium, metric, indexSpec);
                    break;
                }
                case COMPLEX: {
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(type.getComplexTypeName());
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", type.getComplexTypeName());
                    }
                    writer = serde.getSerializer(segmentWriteOutMedium, metric);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", type);
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    static GenericColumnSerializer createLongColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return LongColumnSerializer.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getLongEncoding());
        }
        return LongColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getLongEncoding(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createDoubleColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return DoubleColumnSerializer.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression());
        }
        return DoubleColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    static GenericColumnSerializer createFloatColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String columnName, IndexSpec indexSpec) {
        if (NullHandling.replaceWithDefault()) {
            return FloatColumnSerializer.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression());
        }
        return FloatColumnSerializerV2.create(columnName, segmentWriteOutMedium, columnName, indexSpec.getMetricCompression(), indexSpec.getBitmapSerdeFactory());
    }

    private void writeDimValuesAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, List<DimensionMergerV9> mergers) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            mergers.get(dimIndex).writeMergedValueDictionary(indexes);
        }
        progress.stopSection("setup dimension conversions");
    }

    private void mergeFormat(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ColumnFormat> metricTypes, List<ColumnFormat> dimFormats) {
        HashMap<String, ColumnFormat> columnFormats = new HashMap<String, ColumnFormat>();
        for (IndexableAdapter adapter : adapters) {
            ColumnFormat format;
            for (String dimension : adapter.getDimensionNames()) {
                format = adapter.getFormat(dimension);
                columnFormats.compute(dimension, (d, existingFormat) -> existingFormat == null ? format : format.merge((ColumnFormat)existingFormat));
            }
            for (String metric : adapter.getMetricNames()) {
                format = adapter.getFormat(metric);
                ColumnFormat merged = columnFormats.compute(metric, (m, existingFormat) -> existingFormat == null ? format : format.merge((ColumnFormat)existingFormat));
                metricTypes.put(metric, merged);
            }
        }
        for (String dim : mergedDimensions) {
            dimFormats.add((ColumnFormat)columnFormats.get(dim));
        }
    }

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        DateTime firstTimestamp = index.getMinTime();
        DateTime lastTimestamp = index.getMaxTime();
        if (!dataInterval.contains((ReadableInstant)firstTimestamp) || !dataInterval.contains((ReadableInstant)lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", dataInterval, firstTimestamp, lastTimestamp);
        }
        FileUtils.mkdirp(outDir);
        log.debug("Starting persist for interval[%s], rows[%,d]", dataInterval, index.size());
        return this.multiphaseMerge(Collections.singletonList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), false, index.getMetricAggs(), index.getDimensionsSpec(), outDir, indexSpec, indexSpec, progress, segmentWriteOutMediumFactory, -1);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, IndexSpec indexSpecForIntermediatePersists, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
        return this.multiphaseMerge(IndexMerger.toIndexableAdapters(indexes), rollup, metricAggs, dimensionsSpec, outDir, indexSpec, indexSpecForIntermediatePersists, progress, segmentWriteOutMediumFactory, maxColumnsToMerge);
    }

    @Override
    public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, DimensionsSpec dimensionsSpec, IndexSpec indexSpec, int maxColumnsToMerge) throws IOException {
        return this.multiphaseMerge(indexes, rollup, metricAggs, dimensionsSpec, outDir, indexSpec, indexSpec, new BaseProgressIndicator(), null, maxColumnsToMerge);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File multiphaseMerge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, IndexSpec indexSpecForIntermediatePersists, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
        FileUtils.deleteDirectory(outDir);
        FileUtils.mkdirp(outDir);
        tempDirs = new ArrayList<File>();
        if (maxColumnsToMerge == -1) {
            return this.merge(indexes, rollup, metricAggs, dimensionsSpec, outDir, indexSpec, progress, segmentWriteOutMediumFactory);
        }
        currentPhases = this.getMergePhases(indexes, maxColumnsToMerge);
        currentOutputs = new ArrayList<File>();
        IndexMergerV9.log.debug("base outDir: " + outDir, new Object[0]);
        try {
            tierCounter = 0;
lbl11:
            // 2 sources

            while (true) {
                IndexMergerV9.log.info("Merging %d phases, tiers finished processed so far: %d.", new Object[]{currentPhases.size(), tierCounter});
                for (List<IndexableAdapter> phase : currentPhases) {
                    v0 = isFinalPhase = currentPhases.size() == 1;
                    if (isFinalPhase) {
                        phaseOutDir = outDir;
                        IndexMergerV9.log.info("Performing final merge phase.", new Object[0]);
                    } else {
                        phaseOutDir = FileUtils.createTempDir();
                        tempDirs.add(phaseOutDir);
                    }
                    IndexMergerV9.log.info("Merging phase with %d indexes.", new Object[]{phase.size()});
                    IndexMergerV9.log.debug("phase outDir: " + phaseOutDir, new Object[0]);
                    phaseOutput = this.merge(phase, rollup, metricAggs, dimensionsSpec, phaseOutDir, isFinalPhase != false ? indexSpec : indexSpecForIntermediatePersists, progress, segmentWriteOutMediumFactory);
                    currentOutputs.add(phaseOutput);
                }
                if (currentOutputs.size() == 1) {
                    var15_15 = (File)currentOutputs.get(0);
                    var16_16 = tempDirs.iterator();
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var20_22) {
            var21_23 = tempDirs.iterator();
            while (true) {
                if (!var21_23.hasNext()) {
                    throw var20_22;
                }
                tempDir = (File)var21_23.next();
                if (!tempDir.exists()) continue;
                try {
                    FileUtils.deleteDirectory(tempDir);
                }
                catch (Exception e) {
                    IndexMergerV9.log.warn(e, "Failed to remove directory[%s]", new Object[]{tempDir});
                }
            }
        }
        while (true) {
            if (!var16_16.hasNext()) {
                return var15_15;
            }
            tempDir = (File)var16_16.next();
            if (!tempDir.exists()) continue;
            try {
                FileUtils.deleteDirectory(tempDir);
            }
            catch (Exception e) {
                IndexMergerV9.log.warn(e, "Failed to remove directory[%s]", new Object[]{tempDir});
            }
        }
lbl-1000:
        // 1 sources

        {
            qIndexAdapters = new ArrayList<IndexableAdapter>();
            for (File outputFile : currentOutputs) {
                qIndex = this.indexIO.loadIndex(outputFile, true, SegmentLazyLoadFailCallback.NOOP);
                qIndexAdapters.add(new QueryableIndexIndexableAdapter(qIndex));
            }
            currentPhases = this.getMergePhases(qIndexAdapters, maxColumnsToMerge);
            currentOutputs = new ArrayList<E>();
            ++tierCounter;
            ** continue;
        }
    }

    private List<List<IndexableAdapter>> getMergePhases(List<IndexableAdapter> indexes, int maxColumnsToMerge) {
        ArrayList<List<IndexableAdapter>> toMerge = new ArrayList<List<IndexableAdapter>>();
        if (indexes.size() <= 2) {
            if (this.getIndexColumnCount(indexes) > maxColumnsToMerge) {
                log.info("index pair has more columns than maxColumnsToMerge [%d].", maxColumnsToMerge);
            }
            toMerge.add(indexes);
        } else {
            ArrayList<IndexableAdapter> currentPhase = new ArrayList<IndexableAdapter>();
            int currentColumnCount = 0;
            for (IndexableAdapter index : indexes) {
                int indexColumnCount = this.getIndexColumnCount(index);
                if (indexColumnCount > maxColumnsToMerge) {
                    log.info("index has more columns [%d] than maxColumnsToMerge [%d]!", indexColumnCount, maxColumnsToMerge);
                }
                if (currentPhase.size() > 1 && currentColumnCount + indexColumnCount > maxColumnsToMerge) {
                    toMerge.add(currentPhase);
                    currentPhase = new ArrayList();
                    currentColumnCount = indexColumnCount;
                    currentPhase.add(index);
                    continue;
                }
                currentPhase.add(index);
                currentColumnCount += indexColumnCount;
            }
            toMerge.add(currentPhase);
        }
        return toMerge;
    }

    private int getIndexColumnCount(IndexableAdapter indexableAdapter) {
        return 1 + indexableAdapter.getDimensionNames().size() + indexableAdapter.getMetricNames().size();
    }

    private int getIndexColumnCount(List<IndexableAdapter> indexableAdapters) {
        int count = 0;
        for (IndexableAdapter indexableAdapter : indexableAdapters) {
            count += this.getIndexColumnCount(indexableAdapter);
        }
        return count;
    }

    private File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        int i;
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes, dimensionsSpec);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(indexes.stream().map(IndexableAdapter::getMetricNames).collect(Collectors.toList()));
        AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (AggregatorFactory metricAgg : metricAggs) {
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", mergedMetrics.get(i));
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", i, sortedMetricAggs[i].getName(), mergedMetrics.get(i));
        }
        Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn = rollup ? rowIterators -> new RowCombiningTimeAndDimsIterator((List<TransformableRowIterator>)rowIterators, sortedMetricAggs, (List<String>)mergedMetrics) : MergingRowIterator::new;
        return this.makeIndexFiles(indexes, sortedMetricAggs, outDir, progress, mergedDimensions, new DimensionsSpecInspector(this.storeEmptyColumns, dimensionsSpec), mergedMetrics, rowMergerFn, true, indexSpec, segmentWriteOutMediumFactory);
    }

    private Map<String, DimensionHandler> makeDimensionHandlers(List<String> mergedDimensions, List<ColumnFormat> dimFormats) {
        LinkedHashMap<String, DimensionHandler> handlers = new LinkedHashMap<String, DimensionHandler>();
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            String dimName = mergedDimensions.get(i);
            DimensionHandler handler = dimFormats.get(i).getColumnHandler(dimName);
            handlers.put(dimName, handler);
        }
        return handlers;
    }

    private TimeAndDimsIterator makeMergedTimeAndDimsIterator(List<IndexableAdapter> indexes, List<String> mergedDimensions, List<String> mergedMetrics, Function<List<TransformableRowIterator>, TimeAndDimsIterator> rowMergerFn, Map<String, DimensionHandler> handlers, List<DimensionMergerV9> mergers) {
        ArrayList perIndexRowIterators = Lists.newArrayListWithCapacity((int)indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            TransformableRowIterator target = adapter.getRows();
            if (!mergedDimensions.equals(adapter.getDimensionNames()) || !mergedMetrics.equals(adapter.getMetricNames())) {
                target = this.makeRowIteratorWithReorderedColumns(mergedDimensions, mergedMetrics, handlers, adapter, target);
            }
            perIndexRowIterators.add(IndexMerger.toMergedIndexRowIterator(target, i, mergers));
        }
        return rowMergerFn.apply(perIndexRowIterators);
    }

    private TransformableRowIterator makeRowIteratorWithReorderedColumns(List<String> reorderedDimensions, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, TransformableRowIterator originalIterator) {
        final RowPointer reorderedRowPointer = IndexMergerV9.reorderRowPointerColumns(reorderedDimensions, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getPointer());
        final TimeAndDimsPointer reorderedMarkedRowPointer = IndexMergerV9.reorderRowPointerColumns(reorderedDimensions, reorderedMetrics, originalHandlers, originalAdapter, originalIterator.getMarkedPointer());
        return new ForwardingRowIterator(originalIterator){

            @Override
            public RowPointer getPointer() {
                return reorderedRowPointer;
            }

            @Override
            public TimeAndDimsPointer getMarkedPointer() {
                return reorderedMarkedRowPointer;
            }
        };
    }

    private static <T extends TimeAndDimsPointer> T reorderRowPointerColumns(List<String> reorderedDimensions, List<String> reorderedMetrics, Map<String, DimensionHandler> originalHandlers, IndexableAdapter originalAdapter, T originalRowPointer) {
        ColumnValueSelector[] reorderedDimensionSelectors = (ColumnValueSelector[])reorderedDimensions.stream().map(dimName -> {
            int dimIndex = originalAdapter.getDimensionNames().indexOf(dimName);
            if (dimIndex >= 0) {
                return originalRowPointer.getDimensionSelector(dimIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        List<DimensionHandler> reorderedHandlers = reorderedDimensions.stream().map(originalHandlers::get).collect(Collectors.toList());
        ColumnValueSelector[] reorderedMetricSelectors = (ColumnValueSelector[])reorderedMetrics.stream().map(metricName -> {
            int metricIndex = originalAdapter.getMetricNames().indexOf(metricName);
            if (metricIndex >= 0) {
                return originalRowPointer.getMetricSelector(metricIndex);
            }
            return NilColumnValueSelector.instance();
        }).toArray(ColumnValueSelector[]::new);
        if (originalRowPointer instanceof RowPointer) {
            return (T)new RowPointer(originalRowPointer.timestampSelector, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics, ((RowPointer)originalRowPointer).rowNumPointer);
        }
        return (T)new TimeAndDimsPointer(originalRowPointer.timestampSelector, reorderedDimensionSelectors, reorderedHandlers, reorderedMetricSelectors, reorderedMetrics);
    }

    private static class DimensionsSpecInspector {
        private final boolean storeEmptyColumns;
        private final Set<String> explicitDimensions;
        private final boolean includeAllDimensions;

        private DimensionsSpecInspector(boolean storeEmptyColumns, @Nullable DimensionsSpec dimensionsSpec) {
            this.storeEmptyColumns = storeEmptyColumns;
            this.explicitDimensions = dimensionsSpec == null ? ImmutableSet.of() : new HashSet<String>(dimensionsSpec.getDimensionNames());
            this.includeAllDimensions = dimensionsSpec != null && (dimensionsSpec.isIncludeAllDimensions() || dimensionsSpec.useSchemaDiscovery());
        }

        private boolean shouldStore(String dimension) {
            return this.storeEmptyColumns && (this.includeAllDimensions || this.explicitDimensions.contains(dimension));
        }
    }

    private static class IndexMergeResult {
        @Nullable
        private final List<IntBuffer> rowNumConversions;
        private final int rowCount;

        private IndexMergeResult(@Nullable List<IntBuffer> rowNumConversions, int rowCount) {
            this.rowNumConversions = rowNumConversions;
            this.rowCount = rowCount;
        }
    }
}

