/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeFactory;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategy;

public abstract class BaseTypeSignature<Type extends TypeDescriptor>
implements TypeSignature<Type> {
    protected final Type type;
    @Nullable
    protected final String complexTypeName;
    @Nullable
    protected final TypeSignature<Type> elementType;
    private final Supplier<TypeStrategy> typeStrategy;
    private final Supplier<NullableTypeStrategy> nullableTypeStrategy;

    public BaseTypeSignature(TypeFactory typeFactory, Type type, @Nullable String complexTypeName, @Nullable TypeSignature<Type> elementType) {
        this.type = type;
        this.complexTypeName = complexTypeName;
        this.elementType = elementType;
        this.typeStrategy = Suppliers.memoize(() -> typeFactory.getTypeStrategy(this));
        this.nullableTypeStrategy = Suppliers.memoize(() -> new NullableTypeStrategy((TypeStrategy)this.typeStrategy.get()));
    }

    @Override
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    @JsonProperty(value="complexTypeName")
    public String getComplexTypeName() {
        return this.complexTypeName;
    }

    @Override
    @Nullable
    @JsonProperty(value="elementType")
    public TypeSignature<Type> getElementType() {
        return this.elementType;
    }

    @Override
    public <T> TypeStrategy<T> getStrategy() {
        return (TypeStrategy)this.typeStrategy.get();
    }

    @Override
    public <T> NullableTypeStrategy<T> getNullableStrategy() {
        return (NullableTypeStrategy)this.nullableTypeStrategy.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTypeSignature that = (BaseTypeSignature)o;
        return this.type.equals(that.type) && Objects.equals(this.complexTypeName, that.complexTypeName) && Objects.equals(this.elementType, that.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.complexTypeName, this.elementType);
    }

    public String toString() {
        return this.asTypeString();
    }
}

