/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.utils.CloseableUtils;

public class StringUtf8DictionaryEncodedColumn
implements DictionaryEncodedColumn<String>,
NestedCommonFormatColumn {
    @Nullable
    private final ColumnarInts column;
    @Nullable
    private final ColumnarMultiInts multiValueColumn;
    private final Indexed<ByteBuffer> utf8Dictionary;

    public StringUtf8DictionaryEncodedColumn(@Nullable ColumnarInts singleValueColumn, @Nullable ColumnarMultiInts multiValueColumn, Indexed<ByteBuffer> utf8Dictionary) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.utf8Dictionary = utf8Dictionary;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        if (!this.hasMultipleValues()) {
            throw new UnsupportedOperationException("Column is not multi-valued");
        }
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ByteBuffer buffer = this.utf8Dictionary.get(id);
        if (buffer == null) {
            return null;
        }
        return StringUtils.fromUtf8(buffer);
    }

    @Override
    public int lookupId(String name) {
        return this.utf8Dictionary.indexOf(StringUtils.toUtf8ByteBuffer(name));
    }

    @Override
    public int getCardinality() {
        return this.utf8Dictionary.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        if (this.hasMultipleValues()) {
            class MultiValueDimensionSelector
            extends 1QueryableDimensionSelector {
                MultiValueDimensionSelector() {
                    abstract class QueryableDimensionSelector
                    extends AbstractDimensionSelector
                    implements HistoricalDimensionSelector,
                    IdLookup {
                        final /* synthetic */ ExtractionFn val$extractionFn;

                        QueryableDimensionSelector() {
                            this.val$extractionFn = extractionFn;
                        }

                        @Override
                        public int getValueCardinality() {
                            return StringUtf8DictionaryEncodedColumn.this.getCardinality();
                        }

                        @Override
                        public String lookupName(int id) {
                            String value = StringUtf8DictionaryEncodedColumn.this.lookupName(id);
                            return this.val$extractionFn == null ? value : this.val$extractionFn.apply(value);
                        }

                        @Override
                        @Nullable
                        public ByteBuffer lookupNameUtf8(int id) {
                            return (ByteBuffer)StringUtf8DictionaryEncodedColumn.this.utf8Dictionary.get(id);
                        }

                        @Override
                        public boolean supportsLookupNameUtf8() {
                            return true;
                        }

                        @Override
                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public IdLookup idLookup() {
                            return this.val$extractionFn == null ? this : null;
                        }

                        @Override
                        public int lookupId(String name) {
                            if (this.val$extractionFn != null) {
                                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                            }
                            return StringUtf8DictionaryEncodedColumn.this.lookupId(name);
                        }
                    }
                    super(StringUtf8DictionaryEncodedColumn.this, extractionFn2);
                }

                @Override
                public IndexedInts getRow() {
                    return StringUtf8DictionaryEncodedColumn.this.multiValueColumn.get(offset.getOffset());
                }

                @Override
                public IndexedInts getRow(int offset2) {
                    return StringUtf8DictionaryEncodedColumn.this.multiValueColumn.get(offset2);
                }

                @Override
                public ValueMatcher makeValueMatcher(@Nullable String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                }

                @Override
                public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.defaultGetObject();
                }

                @Override
                public Class classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("multiValueColumn", StringUtf8DictionaryEncodedColumn.this.multiValueColumn);
                    inspector.visit("offset", offset);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new MultiValueDimensionSelector();
        }
        class SingleValueQueryableDimensionSelector
        extends 1QueryableDimensionSelector
        implements SingleValueHistoricalDimensionSelector {
            private final SingleIndexedInt row;

            SingleValueQueryableDimensionSelector() {
                super(StringUtf8DictionaryEncodedColumn.this, extractionFn2);
                this.row = new SingleIndexedInt();
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return StringUtf8DictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return StringUtf8DictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = super.lookupId(value);
                    final int nullId = super.lookupId(null);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches(boolean includeUnknown) {
                                int rowId = this.getRowValue();
                                return includeUnknown && rowId == nullId || rowId == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", StringUtf8DictionaryEncodedColumn.this);
                            }
                        };
                    }
                    if (nullId < 0) {
                        return ValueMatchers.allFalse();
                    }
                    return new ValueMatcher(){

                        @Override
                        public boolean matches(boolean includeUnknown) {
                            return includeUnknown && this.getRowValue() == 0;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("column", StringUtf8DictionaryEncodedColumn.this);
                        }
                    };
                }
                return this.makeValueMatcher(StringPredicateDruidPredicateFactory.equalTo(value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final DruidPredicateFactory predicateFactory) {
                final BitSet checkedIds = new BitSet(StringUtf8DictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(StringUtf8DictionaryEncodedColumn.this.getCardinality());
                final Predicate<String> predicate = predicateFactory.makeStringPredicate();
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matchNull = includeUnknown && predicateFactory.isNullInputUnknown();
                        String rowValue = this.lookupName(id);
                        boolean matches = matchNull && rowValue == null || predicate.apply((Object)rowValue);
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", StringUtf8DictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return super.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", StringUtf8DictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class StringVectorSelector
        extends StringSingleValueDimensionVectorSelector {
            public StringVectorSelector() {
                super(StringUtf8DictionaryEncodedColumn.this.column, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return StringUtf8DictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringUtf8DictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)StringUtf8DictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringUtf8DictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new StringVectorSelector();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(final ReadableVectorOffset offset) {
        final class MultiStringVectorSelector
        extends StringMultiValueDimensionVectorSelector {
            public MultiStringVectorSelector() {
                super(StringUtf8DictionaryEncodedColumn.this.multiValueColumn, readableVectorOffset);
            }

            @Override
            public int getValueCardinality() {
                return StringUtf8DictionaryEncodedColumn.this.getCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringUtf8DictionaryEncodedColumn.this.lookupName(id);
            }

            @Override
            @Nullable
            public ByteBuffer lookupNameUtf8(int id) {
                return (ByteBuffer)StringUtf8DictionaryEncodedColumn.this.utf8Dictionary.get(id);
            }

            @Override
            public int lookupId(@Nullable String name) {
                return StringUtf8DictionaryEncodedColumn.this.lookupId(name);
            }
        }
        return new MultiStringVectorSelector();
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
        if (!this.hasMultipleValues()) {
            final class StringVectorSelector
            extends StringVectorObjectSelector {
                public StringVectorSelector() {
                    super(StringUtf8DictionaryEncodedColumn.this.column, readableVectorOffset);
                }

                @Override
                @Nullable
                public String lookupName(int id) {
                    return StringUtf8DictionaryEncodedColumn.this.lookupName(id);
                }
            }
            return new StringVectorSelector();
        }
        final class MultiStringVectorSelector
        extends MultiValueStringVectorObjectSelector {
            public MultiStringVectorSelector() {
                super(StringUtf8DictionaryEncodedColumn.this.multiValueColumn, readableVectorOffset);
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                return StringUtf8DictionaryEncodedColumn.this.lookupName(id);
            }
        }
        return new MultiStringVectorSelector();
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll(this.column, this.multiValueColumn);
    }

    @Override
    public ColumnType getLogicalType() {
        return ColumnType.STRING;
    }

    @Override
    public Indexed<String> getStringDictionary() {
        return new StringEncodingStrategies.Utf8ToStringIndexed(this.utf8Dictionary);
    }

    public static abstract class MultiValueStringVectorObjectSelector
    implements VectorObjectSelector {
        private final ColumnarMultiInts multiValueColumn;
        private final ReadableVectorOffset offset;
        private final IndexedInts[] vector;
        private final Object[] strings;
        private int id = -1;

        public MultiValueStringVectorObjectSelector(ColumnarMultiInts multiValueColumn, ReadableVectorOffset offset) {
            this.multiValueColumn = multiValueColumn;
            this.offset = offset;
            this.vector = new IndexedInts[offset.getMaxVectorSize()];
            this.strings = new Object[offset.getMaxVectorSize()];
        }

        @Nullable
        public abstract String lookupName(int var1);

        @Override
        public Object[] getObjectVector() {
            int i;
            int numRows;
            if (this.id == this.offset.getId()) {
                return this.strings;
            }
            if (this.offset.isContiguous()) {
                int currentOffset = this.offset.getStartOffset();
                numRows = this.offset.getCurrentVectorSize();
                for (i = 0; i < numRows; ++i) {
                    this.vector[i] = this.multiValueColumn.getUnshared(i + currentOffset);
                }
            } else {
                int[] offsets = this.offset.getOffsets();
                numRows = this.offset.getCurrentVectorSize();
                for (i = 0; i < numRows; ++i) {
                    this.vector[i] = this.multiValueColumn.getUnshared(offsets[i]);
                }
            }
            for (int i2 = 0; i2 < this.offset.getCurrentVectorSize(); ++i2) {
                IndexedInts ithRow = this.vector[i2];
                int size = ithRow.size();
                if (size == 0) {
                    this.strings[i2] = null;
                    continue;
                }
                if (size == 1) {
                    this.strings[i2] = this.lookupName(ithRow.get(0));
                    continue;
                }
                ArrayList row = Lists.newArrayListWithCapacity((int)size);
                for (int j = 0; j < size; ++j) {
                    row.add(this.lookupName(ithRow.get(j)));
                }
                this.strings[i2] = row;
            }
            this.id = this.offset.getId();
            return this.strings;
        }

        @Override
        public int getMaxVectorSize() {
            return this.offset.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }
    }

    public static abstract class StringVectorObjectSelector
    implements VectorObjectSelector {
        private final ColumnarInts column;
        private final ReadableVectorOffset offset;
        private final int[] vector;
        private final Object[] strings;
        private int id = -1;

        public StringVectorObjectSelector(ColumnarInts column, ReadableVectorOffset offset) {
            this.column = column;
            this.offset = offset;
            this.vector = new int[offset.getMaxVectorSize()];
            this.strings = new Object[offset.getMaxVectorSize()];
        }

        @Override
        public Object[] getObjectVector() {
            if (this.id == this.offset.getId()) {
                return this.strings;
            }
            if (this.offset.isContiguous()) {
                this.column.get(this.vector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
            } else {
                this.column.get(this.vector, this.offset.getOffsets(), this.offset.getCurrentVectorSize());
            }
            for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                this.strings[i] = this.lookupName(this.vector[i]);
            }
            this.id = this.offset.getId();
            return this.strings;
        }

        @Override
        public int getMaxVectorSize() {
            return this.offset.getMaxVectorSize();
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }

        @Nullable
        public abstract String lookupName(int var1);
    }

    public static abstract class StringMultiValueDimensionVectorSelector
    implements MultiValueDimensionVectorSelector,
    IdLookup {
        private final ColumnarMultiInts multiValueColumn;
        private final ReadableVectorOffset offset;
        private final IndexedInts[] vector;
        private int id = -1;

        public StringMultiValueDimensionVectorSelector(ColumnarMultiInts multiValueColumn, ReadableVectorOffset offset) {
            this.multiValueColumn = multiValueColumn;
            this.offset = offset;
            this.vector = new IndexedInts[offset.getMaxVectorSize()];
        }

        @Override
        public IndexedInts[] getRowVector() {
            if (this.id == this.offset.getId()) {
                return this.vector;
            }
            if (this.offset.isContiguous()) {
                int currentOffset = this.offset.getStartOffset();
                int numRows = this.offset.getCurrentVectorSize();
                for (int i = 0; i < numRows; ++i) {
                    this.vector[i] = this.multiValueColumn.getUnshared(i + currentOffset);
                }
            } else {
                int[] offsets = this.offset.getOffsets();
                int numRows = this.offset.getCurrentVectorSize();
                for (int i = 0; i < numRows; ++i) {
                    this.vector[i] = this.multiValueColumn.getUnshared(offsets[i]);
                }
            }
            this.id = this.offset.getId();
            return this.vector;
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return true;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return true;
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return this;
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }

        @Override
        public int getMaxVectorSize() {
            return this.offset.getMaxVectorSize();
        }
    }

    public static abstract class StringSingleValueDimensionVectorSelector
    implements SingleValueDimensionVectorSelector,
    IdLookup {
        private final ColumnarInts column;
        private final ReadableVectorOffset offset;
        private final int[] vector;
        private int id = -1;

        public StringSingleValueDimensionVectorSelector(ColumnarInts column, ReadableVectorOffset offset) {
            this.column = column;
            this.offset = offset;
            this.vector = new int[offset.getMaxVectorSize()];
        }

        @Override
        public int[] getRowVector() {
            if (this.id == this.offset.getId()) {
                return this.vector;
            }
            if (this.offset.isContiguous()) {
                this.column.get(this.vector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
            } else {
                this.column.get(this.vector, this.offset.getOffsets(), this.offset.getCurrentVectorSize());
            }
            this.id = this.offset.getId();
            return this.vector;
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return true;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return true;
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return this;
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }

        @Override
        public int getMaxVectorSize() {
            return this.offset.getMaxVectorSize();
        }
    }
}

