/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;

public final class IndexedStringDruidPredicateIndexes<TDictionary extends Indexed<String>>
implements DruidPredicateIndexes {
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;
    private final ColumnConfig columnConfig;
    private final int numRows;

    public IndexedStringDruidPredicateIndexes(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps, @Nullable ColumnConfig columnConfig, int numRows) {
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
        this.columnConfig = columnConfig;
        this.numRows = numRows;
    }

    @Override
    @Nullable
    public BitmapColumnIndex forPredicate(final DruidPredicateFactory matcherFactory) {
        if (ColumnIndexSupplier.skipComputingPredicateIndexes(this.columnConfig, this.numRows, this.dictionary.size())) {
            return null;
        }
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    @Nullable
                    String next;
                    boolean nextSet;
                    final Predicate stringPredicate;
                    final Iterator iterator;
                    {
                        this.stringPredicate = matcherFactory.makeStringPredicate();
                        this.iterator = IndexedStringDruidPredicateIndexes.this.dictionary.iterator();
                        this.next = null;
                        this.nextSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.nextSet) {
                            this.findNext();
                        }
                        return this.nextSet;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (!this.nextSet) {
                            this.findNext();
                            if (!this.nextSet) {
                                throw new NoSuchElementException();
                            }
                        }
                        this.nextSet = false;
                        int idx = IndexedStringDruidPredicateIndexes.this.dictionary.indexOf(this.next);
                        if (idx < 0) {
                            return IndexedStringDruidPredicateIndexes.this.bitmapFactory.makeEmptyImmutableBitmap();
                        }
                        ImmutableBitmap bitmap = (ImmutableBitmap)IndexedStringDruidPredicateIndexes.this.bitmaps.get(idx);
                        return bitmap == null ? IndexedStringDruidPredicateIndexes.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
                    }

                    private void findNext() {
                        while (!this.nextSet && this.iterator.hasNext()) {
                            String nextValue = (String)this.iterator.next();
                            this.nextSet = this.stringPredicate.apply((Object)nextValue);
                            if (!this.nextSet) continue;
                            this.next = nextValue;
                        }
                    }
                };
            }

            @Override
            @Nullable
            protected ImmutableBitmap getUnknownsBitmap() {
                if (matcherFactory.isNullInputUnknown() && NullHandling.isNullOrEquivalent((String)IndexedStringDruidPredicateIndexes.this.dictionary.get(0))) {
                    return (ImmutableBitmap)IndexedStringDruidPredicateIndexes.this.bitmaps.get(0);
                }
                return null;
            }
        };
    }
}

