/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.SimpleImmutableBitmapIterableIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.Utf8ValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;

public final class IndexedUtf8ValueIndexes<TDictionary extends Indexed<ByteBuffer>>
implements StringValueSetIndexes,
Utf8ValueSetIndexes,
ValueIndexes {
    private static final double SORTED_MERGE_RATIO_THRESHOLD = 0.12;
    private static final int SIZE_WORTH_CHECKING_MIN = 8;
    private static final Comparator<ByteBuffer> COMPARATOR = ByteBufferUtils.utf8Comparator();
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedUtf8ValueIndexes(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        Preconditions.checkArgument((boolean)dictionary.isSorted(), (Object)"Dictionary must be sorted");
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    public BitmapColumnIndex forValue(@Nullable String value) {
        final ByteBuffer utf8 = StringUtils.toUtf8ByteBuffer(value);
        return new SimpleBitmapColumnIndex(){

            @Override
            public double estimateSelectivity(int totalRows) {
                return Math.min(1.0, (double)this.getBitmapForValue().size() / (double)totalRows);
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                if (includeUnknown && NullHandling.isNullOrEquivalent((ByteBuffer)IndexedUtf8ValueIndexes.this.dictionary.get(0))) {
                    return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)this.getBitmapForValue(), (Object)IndexedUtf8ValueIndexes.this.getBitmap(0)));
                }
                return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
            }

            private ImmutableBitmap getBitmapForValue() {
                int idx = IndexedUtf8ValueIndexes.this.dictionary.indexOf(utf8);
                return IndexedUtf8ValueIndexes.this.getBitmap(idx);
            }
        };
    }

    @Override
    @Nullable
    public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
        if (valueType.isPrimitive()) {
            return this.forValue(ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value).castTo(ExpressionType.STRING).asString());
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public BitmapColumnIndex forSortedValues(SortedSet<String> values) {
        return this.getBitmapColumnIndexForSortedIterableUtf8(Iterables.transform(values, StringUtils::toUtf8ByteBuffer), values.size(), values.contains(null));
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public BitmapColumnIndex forSortedValuesUtf8(SortedSet<ByteBuffer> valuesUtf8) {
        SortedSet<ByteBuffer> tailSet;
        if (valuesUtf8.size() >= 8) {
            ByteBuffer minValueInColumn = (ByteBuffer)this.dictionary.get(0);
            tailSet = valuesUtf8.tailSet(minValueInColumn);
        } else {
            tailSet = valuesUtf8;
        }
        return this.getBitmapColumnIndexForSortedIterableUtf8(tailSet, tailSet.size(), valuesUtf8.contains(null));
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private BitmapColumnIndex getBitmapColumnIndexForSortedIterableUtf8(final Iterable<ByteBuffer> valuesUtf8, int size, final boolean valuesContainsNull) {
        if ((double)size > 0.12 * (double)this.dictionary.size()) {
            return new SimpleImmutableBitmapIterableIndex(){

                @Override
                public Iterable<ImmutableBitmap> getBitmapIterable() {
                    return () -> new Iterator<ImmutableBitmap>(){
                        int next;
                        int idx;
                        final PeekingIterator valuesIterator;
                        final PeekingIterator dictionaryIterator;
                        {
                            this.valuesIterator = Iterators.peekingIterator(valuesUtf8.iterator());
                            this.dictionaryIterator = Iterators.peekingIterator(IndexedUtf8ValueIndexes.this.dictionary.iterator());
                            this.next = -1;
                            this.idx = 0;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next < 0) {
                                this.findNext();
                            }
                            return this.next >= 0;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            if (this.next < 0) {
                                this.findNext();
                                if (this.next < 0) {
                                    throw new NoSuchElementException();
                                }
                            }
                            int swap = this.next;
                            this.next = -1;
                            return IndexedUtf8ValueIndexes.this.getBitmap(swap);
                        }

                        private void findNext() {
                            while (this.next < 0 && this.valuesIterator.hasNext() && this.dictionaryIterator.hasNext()) {
                                ByteBuffer nextValue = (ByteBuffer)this.valuesIterator.peek();
                                ByteBuffer nextDictionaryKey = (ByteBuffer)this.dictionaryIterator.peek();
                                int comparison = COMPARATOR.compare(nextValue, nextDictionaryKey);
                                if (comparison == 0) {
                                    this.next = this.idx;
                                    this.valuesIterator.next();
                                    break;
                                }
                                if (comparison < 0) {
                                    this.valuesIterator.next();
                                    continue;
                                }
                                this.dictionaryIterator.next();
                                ++this.idx;
                            }
                        }
                    };
                }

                @Override
                @Nullable
                protected ImmutableBitmap getUnknownsBitmap() {
                    if (!valuesContainsNull && NullHandling.isNullOrEquivalent((ByteBuffer)IndexedUtf8ValueIndexes.this.dictionary.get(0))) {
                        return (ImmutableBitmap)IndexedUtf8ValueIndexes.this.bitmaps.get(0);
                    }
                    return null;
                }
            };
        }
        return this.getSimpleImmutableBitmapIterableIndexFromIterator(valuesUtf8, valuesContainsNull);
    }

    private SimpleImmutableBitmapIterableIndex getSimpleImmutableBitmapIterableIndexFromIterator(final Iterable<ByteBuffer> valuesUtf8, final boolean valuesContainsNull) {
        return new SimpleImmutableBitmapIterableIndex(){

            @Override
            public Iterable<ImmutableBitmap> getBitmapIterable() {
                return () -> new Iterator<ImmutableBitmap>(){
                    final int dictionarySize;
                    int next;
                    final Iterator iterator;
                    {
                        this.dictionarySize = IndexedUtf8ValueIndexes.this.dictionary.size();
                        this.iterator = valuesUtf8.iterator();
                        this.next = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next < 0) {
                            this.findNext();
                        }
                        return this.next >= 0;
                    }

                    @Override
                    public ImmutableBitmap next() {
                        if (this.next < 0) {
                            this.findNext();
                            if (this.next < 0) {
                                throw new NoSuchElementException();
                            }
                        }
                        int swap = this.next;
                        this.next = -1;
                        return IndexedUtf8ValueIndexes.this.getBitmap(swap);
                    }

                    private void findNext() {
                        while (this.next < 0 && this.iterator.hasNext()) {
                            ByteBuffer nextValue = (ByteBuffer)this.iterator.next();
                            this.next = IndexedUtf8ValueIndexes.this.dictionary.indexOf(nextValue);
                            if (this.next != -this.dictionarySize - 1) continue;
                            break;
                        }
                    }
                };
            }

            @Override
            @Nullable
            protected ImmutableBitmap getUnknownsBitmap() {
                if (!valuesContainsNull && NullHandling.isNullOrEquivalent((ByteBuffer)IndexedUtf8ValueIndexes.this.dictionary.get(0))) {
                    return (ImmutableBitmap)IndexedUtf8ValueIndexes.this.bitmaps.get(0);
                }
                return null;
            }
        };
    }
}

