/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;

public abstract class SimpleImmutableBitmapIterableIndex
extends SimpleBitmapColumnIndex {
    @Override
    public double estimateSelectivity(int totalRows) {
        return Filters.estimateSelectivity(this.getBitmapIterable().iterator(), totalRows);
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
        ImmutableBitmap unknownsBitmap;
        if (includeUnknown && (unknownsBitmap = this.getUnknownsBitmap()) != null) {
            return bitmapResultFactory.unionDimensionValueBitmaps(Iterables.concat(this.getBitmapIterable(), Collections.singletonList(unknownsBitmap)));
        }
        return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable());
    }

    protected abstract Iterable<ImmutableBitmap> getBitmapIterable();

    @Nullable
    protected abstract ImmutableBitmap getUnknownsBitmap();
}

