/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.filter.cnf.CNFFilterExplosionException;
import org.apache.druid.segment.join.filter.Equiconditions;
import org.apache.druid.segment.join.filter.JoinFilterAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterColumnCorrelationAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterCorrelations;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinFilterSplit;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.JoinFilterRewriteConfig;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;

public class JoinFilterAnalyzer {
    private static final String PUSH_DOWN_VIRTUAL_COLUMN_NAME_BASE = "JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-";

    public static JoinFilterPreAnalysis computeJoinFilterPreAnalysis(JoinFilterPreAnalysisKey key) {
        List<Filter> normalizedOrClauses;
        ArrayList<VirtualColumn> preJoinVirtualColumns = new ArrayList<VirtualColumn>();
        ArrayList<VirtualColumn> postJoinVirtualColumns = new ArrayList<VirtualColumn>();
        JoinableClauses joinableClauses = JoinableClauses.fromList(key.getJoinableClauses());
        joinableClauses.splitVirtualColumns(key.getVirtualColumns(), preJoinVirtualColumns, postJoinVirtualColumns);
        JoinFilterPreAnalysis.Builder preAnalysisBuilder = new JoinFilterPreAnalysis.Builder(key, postJoinVirtualColumns);
        if (key.getFilter() == null || !key.getRewriteConfig().isEnableFilterPushDown()) {
            return preAnalysisBuilder.build();
        }
        try {
            normalizedOrClauses = Filters.toNormalizedOrClauses(key.getFilter());
        }
        catch (CNFFilterExplosionException cnfFilterExplosionException) {
            JoinFilterRewriteConfig configWithoutPushdownAndRewrite = new JoinFilterRewriteConfig(false, false, key.getRewriteConfig().isEnableRewriteValueColumnFilters(), key.getRewriteConfig().isEnableRewriteJoinToFilter(), key.getRewriteConfig().getFilterRewriteMaxSize());
            JoinFilterPreAnalysisKey keyWithoutPushdownAndRewrite = new JoinFilterPreAnalysisKey(configWithoutPushdownAndRewrite, key.getJoinableClauses(), key.getVirtualColumns(), key.getFilter());
            return new JoinFilterPreAnalysis.Builder(keyWithoutPushdownAndRewrite, postJoinVirtualColumns).build();
        }
        ArrayList<Filter> normalizedBaseTableClauses = new ArrayList<Filter>();
        ArrayList<Filter> normalizedJoinTableClauses = new ArrayList<Filter>();
        for (Filter orClause : normalizedOrClauses) {
            Set<String> reqColumns = orClause.getRequiredColumns();
            if (joinableClauses.areSomeColumnsFromJoin(reqColumns) || JoinFilterAnalyzer.areSomeColumnsFromPostJoinVirtualColumns(postJoinVirtualColumns, reqColumns)) {
                normalizedJoinTableClauses.add(orClause);
                continue;
            }
            normalizedBaseTableClauses.add(orClause);
        }
        preAnalysisBuilder.withNormalizedBaseTableClauses(normalizedBaseTableClauses).withNormalizedJoinTableClauses(normalizedJoinTableClauses);
        if (!key.getRewriteConfig().isEnableFilterRewrite()) {
            return preAnalysisBuilder.build();
        }
        Equiconditions equiconditions = preAnalysisBuilder.computeEquiconditionsFromJoinableClauses();
        JoinFilterCorrelations correlations = JoinFilterCorrelations.computeJoinFilterCorrelations(normalizedJoinTableClauses, equiconditions, joinableClauses, key.getRewriteConfig().isEnableRewriteValueColumnFilters(), key.getRewriteConfig().getFilterRewriteMaxSize());
        return preAnalysisBuilder.withCorrelations(correlations).build();
    }

    public static JoinFilterSplit splitFilter(JoinFilterPreAnalysis joinFilterPreAnalysis) {
        return JoinFilterAnalyzer.splitFilter(joinFilterPreAnalysis, null);
    }

    public static JoinFilterSplit splitFilter(JoinFilterPreAnalysis joinFilterPreAnalysis, @Nullable Filter baseFilter) {
        if (joinFilterPreAnalysis.getOriginalFilter() == null || !joinFilterPreAnalysis.isEnableFilterPushDown()) {
            return new JoinFilterSplit(baseFilter, joinFilterPreAnalysis.getOriginalFilter(), (Set<VirtualColumn>)ImmutableSet.of());
        }
        ArrayList<Filter> leftFilters = new ArrayList<Filter>();
        ArrayList<Filter> rightFilters = new ArrayList<Filter>();
        HashMap<Expr, VirtualColumn> pushDownVirtualColumnsForLhsExprs = new HashMap<Expr, VirtualColumn>();
        if (null != baseFilter) {
            leftFilters.add(baseFilter);
        }
        for (Filter baseTableFilter : joinFilterPreAnalysis.getNormalizedBaseTableClauses()) {
            if (!Filters.filterMatchesNull(baseTableFilter)) {
                leftFilters.add(baseTableFilter);
                continue;
            }
            rightFilters.add(baseTableFilter);
        }
        for (Filter orClause : joinFilterPreAnalysis.getNormalizedJoinTableClauses()) {
            JoinFilterAnalysis joinFilterAnalysis = JoinFilterAnalyzer.analyzeJoinFilterClause(orClause, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
            if (joinFilterAnalysis.isCanPushDown()) {
                leftFilters.add(joinFilterAnalysis.getPushDownFilter().get());
            }
            if (!joinFilterAnalysis.isRetainAfterJoin()) continue;
            rightFilters.add(joinFilterAnalysis.getOriginalFilter());
        }
        return new JoinFilterSplit(Filters.maybeAnd(leftFilters).orElse(null), Filters.maybeAnd(rightFilters).orElse(null), new HashSet<VirtualColumn>(pushDownVirtualColumnsForLhsExprs.values()));
    }

    private static JoinFilterAnalysis analyzeJoinFilterClause(Filter filterClause, JoinFilterPreAnalysis joinFilterPreAnalysis, Map<Expr, VirtualColumn> pushDownVirtualColumnsForLhsExprs) {
        if (!joinFilterPreAnalysis.isEnableFilterRewrite() || Filters.filterMatchesNull(filterClause)) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
        }
        if (filterClause instanceof OrFilter) {
            return JoinFilterAnalyzer.rewriteOrFilter((OrFilter)filterClause, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
        }
        if (joinFilterPreAnalysis.getEquiconditions().doesFilterSupportDirectJoinFilterRewrite(filterClause)) {
            return JoinFilterAnalyzer.rewriteFilterDirect(filterClause, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
        }
        if (filterClause instanceof SelectorFilter) {
            return JoinFilterAnalyzer.rewriteSelectorFilter((SelectorFilter)filterClause, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
        }
        return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
    }

    private static JoinFilterAnalysis rewriteFilterDirect(Filter filterClause, JoinFilterPreAnalysis joinFilterPreAnalysis, Map<Expr, VirtualColumn> pushDownVirtualColumnsForLhsExprs) {
        if (!filterClause.supportsRequiredColumnRewrite()) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
        }
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        String reqColumn = filterClause.getRequiredColumns().iterator().next();
        List<JoinFilterColumnCorrelationAnalysis> correlationAnalyses = joinFilterPreAnalysis.getCorrelationsByDirectFilteringColumn().get(reqColumn);
        if (correlationAnalyses == null) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
        }
        for (JoinFilterColumnCorrelationAnalysis correlationAnalysis : correlationAnalyses) {
            if (!correlationAnalysis.supportsPushDown()) continue;
            for (String correlatedBaseColumn : correlationAnalysis.getBaseColumns()) {
                Filter rewrittenFilter = filterClause.rewriteRequiredColumns((Map<String, String>)ImmutableMap.of((Object)reqColumn, (Object)correlatedBaseColumn));
                newFilters.add(rewrittenFilter);
            }
            for (Expr correlatedBaseExpr : correlationAnalysis.getBaseExpressions()) {
                VirtualColumn pushDownVirtualColumn = pushDownVirtualColumnsForLhsExprs.computeIfAbsent(correlatedBaseExpr, expr -> {
                    String vcName = JoinFilterAnalyzer.getCorrelatedBaseExprVirtualColumnName(pushDownVirtualColumnsForLhsExprs.size());
                    return new ExpressionVirtualColumn(vcName, correlatedBaseExpr, ColumnType.STRING);
                });
                Filter rewrittenFilter = filterClause.rewriteRequiredColumns((Map<String, String>)ImmutableMap.of((Object)reqColumn, (Object)pushDownVirtualColumn.getOutputName()));
                newFilters.add(rewrittenFilter);
            }
        }
        if (newFilters.isEmpty()) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
        }
        return new JoinFilterAnalysis(false, filterClause, Filters.maybeAnd(newFilters).orElse(null));
    }

    private static JoinFilterAnalysis rewriteOrFilter(OrFilter orFilter, JoinFilterPreAnalysis joinFilterPreAnalysis, Map<Expr, VirtualColumn> pushDownVirtualColumnsForLhsExprs) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        boolean retainRhs = false;
        for (Filter filter : orFilter.getFilters()) {
            if (!joinFilterPreAnalysis.getJoinableClauses().areSomeColumnsFromJoin(filter.getRequiredColumns())) {
                newFilters.add(filter);
                continue;
            }
            JoinFilterAnalysis rewritten = null;
            if (joinFilterPreAnalysis.getEquiconditions().doesFilterSupportDirectJoinFilterRewrite(filter)) {
                rewritten = JoinFilterAnalyzer.rewriteFilterDirect(filter, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
            } else if (filter instanceof SelectorFilter) {
                retainRhs = true;
                rewritten = JoinFilterAnalyzer.rewriteSelectorFilter((SelectorFilter)filter, joinFilterPreAnalysis, pushDownVirtualColumnsForLhsExprs);
            }
            if (rewritten == null || !rewritten.isCanPushDown()) {
                return JoinFilterAnalysis.createNoPushdownFilterAnalysis(orFilter);
            }
            newFilters.add(rewritten.getPushDownFilter().get());
        }
        return new JoinFilterAnalysis(retainRhs, orFilter, Filters.maybeOr(newFilters).orElse(null));
    }

    private static JoinFilterAnalysis rewriteSelectorFilter(SelectorFilter selectorFilter, JoinFilterPreAnalysis joinFilterPreAnalysis, Map<Expr, VirtualColumn> pushDownVirtualColumnsForLhsExprs) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        String filteringColumn = selectorFilter.getDimension();
        String filteringValue = selectorFilter.getValue();
        if (JoinFilterAnalyzer.areSomeColumnsFromPostJoinVirtualColumns(joinFilterPreAnalysis.getPostJoinVirtualColumns(), selectorFilter.getRequiredColumns())) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        if (!joinFilterPreAnalysis.getJoinableClauses().areSomeColumnsFromJoin(selectorFilter.getRequiredColumns())) {
            return new JoinFilterAnalysis(false, selectorFilter, selectorFilter);
        }
        List<JoinFilterColumnCorrelationAnalysis> correlationAnalyses = joinFilterPreAnalysis.getCorrelationsByFilteringColumn().get(filteringColumn);
        if (correlationAnalyses == null) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        for (JoinFilterColumnCorrelationAnalysis correlationAnalysis : correlationAnalyses) {
            if (!correlationAnalysis.supportsPushDown()) continue;
            Optional<InDimFilter.ValuesSet> correlatedValues = correlationAnalysis.getCorrelatedValuesMap().get(Pair.of(filteringColumn, filteringValue));
            if (!correlatedValues.isPresent()) {
                return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
            }
            InDimFilter.ValuesSet newFilterValues = correlatedValues.get();
            if (newFilterValues.isEmpty()) {
                return new JoinFilterAnalysis(true, selectorFilter, FalseFilter.instance());
            }
            for (String correlatedBaseColumn : correlationAnalysis.getBaseColumns()) {
                Filter rewrittenFilter = new InDimFilter(correlatedBaseColumn, (Set<String>)((Object)newFilterValues)).toFilter();
                newFilters.add(rewrittenFilter);
            }
            for (Expr correlatedBaseExpr : correlationAnalysis.getBaseExpressions()) {
                VirtualColumn pushDownVirtualColumn = pushDownVirtualColumnsForLhsExprs.computeIfAbsent(correlatedBaseExpr, expr -> {
                    String vcName = JoinFilterAnalyzer.getCorrelatedBaseExprVirtualColumnName(pushDownVirtualColumnsForLhsExprs.size());
                    return new ExpressionVirtualColumn(vcName, correlatedBaseExpr, ColumnType.STRING);
                });
                Filter rewrittenFilter = new InDimFilter(pushDownVirtualColumn.getOutputName(), (Set<String>)((Object)newFilterValues)).toFilter();
                newFilters.add(rewrittenFilter);
            }
        }
        if (newFilters.isEmpty()) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        return new JoinFilterAnalysis(true, selectorFilter, Filters.maybeAnd(newFilters).orElse(null));
    }

    private static String getCorrelatedBaseExprVirtualColumnName(int counter) {
        return PUSH_DOWN_VIRTUAL_COLUMN_NAME_BASE + counter;
    }

    private static boolean isColumnFromPostJoinVirtualColumns(List<VirtualColumn> postJoinVirtualColumns, String column) {
        for (VirtualColumn postJoinVirtualColumn : postJoinVirtualColumns) {
            if (!column.equals(postJoinVirtualColumn.getOutputName())) continue;
            return true;
        }
        return false;
    }

    private static boolean areSomeColumnsFromPostJoinVirtualColumns(List<VirtualColumn> postJoinVirtualColumns, Collection<String> columns) {
        for (String column : columns) {
            if (!JoinFilterAnalyzer.isColumnFromPostJoinVirtualColumns(postJoinVirtualColumns, column)) continue;
            return true;
        }
        return false;
    }
}

