/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class FieldTypeInfo {
    private static final byte STRING_MASK = 1;
    private static final byte LONG_MASK = 4;
    private static final byte DOUBLE_MASK = 8;
    private static final byte STRING_ARRAY_MASK = 16;
    private static final byte LONG_ARRAY_MASK = 32;
    private static final byte DOUBLE_ARRAY_MASK = 64;
    private static final ColumnType[] TYPES = new ColumnType[]{ColumnType.STRING, null, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.STRING_ARRAY, ColumnType.LONG_ARRAY, ColumnType.DOUBLE_ARRAY};
    private final ByteBuffer buffer;
    private final int startOffset;

    public static FieldTypeInfo read(ByteBuffer buffer, int length) {
        FieldTypeInfo typeInfo = new FieldTypeInfo(buffer);
        buffer.position(buffer.position() + length);
        return typeInfo;
    }

    public FieldTypeInfo(ByteBuffer buffer) {
        this.buffer = buffer;
        this.startOffset = buffer.position();
    }

    public TypeSet getTypes(int fieldIndex) {
        return new TypeSet(this.buffer.get(this.startOffset + fieldIndex));
    }

    @Nullable
    private static ColumnType getSingleType(byte types) {
        if (Integer.bitCount(types) == 1) {
            return TYPES[Integer.numberOfTrailingZeros(types)];
        }
        return null;
    }

    public static byte add(byte types, ColumnType type) {
        block0 : switch ((ValueType)type.getType()) {
            case STRING: {
                types = (byte)(types | 1);
                break;
            }
            case LONG: {
                types = (byte)(types | 4);
                break;
            }
            case DOUBLE: {
                types = (byte)(types | 8);
                break;
            }
            case ARRAY: {
                Preconditions.checkNotNull(type.getElementType(), (Object)"ElementType must not be null");
                switch ((ValueType)type.getElementType().getType()) {
                    case STRING: {
                        types = (byte)(types | 0x10);
                        break block0;
                    }
                    case LONG: {
                        types = (byte)(types | 0x20);
                        break block0;
                    }
                    case DOUBLE: {
                        types = (byte)(types | 0x40);
                        break block0;
                    }
                }
                throw new ISE("Unsupported nested array type: [%s]", type.asTypeString());
            }
            default: {
                throw new ISE("Unsupported nested type: [%s]", type.asTypeString());
            }
        }
        return types;
    }

    public static Set<ColumnType> convertToSet(byte types) {
        HashSet theTypes = Sets.newHashSetWithExpectedSize((int)4);
        if ((types & 1) > 0) {
            theTypes.add(ColumnType.STRING);
        }
        if ((types & 4) > 0) {
            theTypes.add(ColumnType.LONG);
        }
        if ((types & 8) > 0) {
            theTypes.add(ColumnType.DOUBLE);
        }
        if ((types & 0x10) > 0) {
            theTypes.add(ColumnType.STRING_ARRAY);
        }
        if ((types & 0x40) > 0) {
            theTypes.add(ColumnType.DOUBLE_ARRAY);
        }
        if ((types & 0x20) > 0) {
            theTypes.add(ColumnType.LONG_ARRAY);
        }
        return theTypes;
    }

    public static class Writer
    implements Serializer {
        private final SegmentWriteOutMedium segmentWriteOutMedium;
        @Nullable
        private WriteOutBytes valuesOut = null;
        private int numWritten = 0;

        public Writer(SegmentWriteOutMedium segmentWriteOutMedium) {
            this.segmentWriteOutMedium = segmentWriteOutMedium;
        }

        public void open() throws IOException {
            this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        }

        public void write(MutableTypeSet types) throws IOException {
            this.valuesOut.write(types.getByteValue());
            ++this.numWritten;
        }

        @Override
        public long getSerializedSize() {
            return this.numWritten;
        }

        @Override
        public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.valuesOut.writeTo(channel);
        }
    }

    public static class MutableTypeSet {
        private byte types;
        private boolean hasEmptyArray;

        public MutableTypeSet() {
            this(0);
        }

        public MutableTypeSet(byte types) {
            this.types = types;
        }

        public MutableTypeSet(byte types, boolean hasEmptyArray) {
            this.types = types;
            this.hasEmptyArray = hasEmptyArray;
        }

        public MutableTypeSet add(ColumnType type) {
            this.types = FieldTypeInfo.add(this.types, type);
            return this;
        }

        public MutableTypeSet addUntypedArray() {
            this.hasEmptyArray = true;
            return this;
        }

        public boolean hasUntypedArray() {
            return this.hasEmptyArray;
        }

        public MutableTypeSet merge(byte other, boolean hasEmptyArray) {
            this.types = (byte)(this.types | other);
            this.hasEmptyArray = this.hasEmptyArray || hasEmptyArray;
            return this;
        }

        @Nullable
        public ColumnType getSingleType() {
            ColumnType columnType = FieldTypeInfo.getSingleType(this.types);
            if (this.hasEmptyArray && columnType != null && !columnType.isArray()) {
                return null;
            }
            return columnType;
        }

        public boolean isEmpty() {
            return this.types == 0;
        }

        public byte getByteValue() {
            ColumnType singleType = FieldTypeInfo.getSingleType(this.types);
            if (this.hasEmptyArray && singleType != null && !singleType.isArray()) {
                return FieldTypeInfo.add(this.types, ColumnType.ofArray(singleType));
            }
            return this.types;
        }

        public String toString() {
            return FieldTypeInfo.convertToSet(this.types).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTypeSet typeSet = (MutableTypeSet)o;
            return this.types == typeSet.types && this.hasEmptyArray == typeSet.hasEmptyArray;
        }

        public int hashCode() {
            return Objects.hash(this.types, this.hasEmptyArray);
        }
    }

    public static class TypeSet {
        private final byte types;

        public TypeSet(byte types) {
            this.types = types;
        }

        @Nullable
        public ColumnType getSingleType() {
            return FieldTypeInfo.getSingleType(this.types);
        }

        public byte getByteValue() {
            return this.types;
        }

        public String toString() {
            return FieldTypeInfo.convertToSet(this.types).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeSet typeSet = (TypeSet)o;
            return this.types == typeSet.types;
        }

        public int hashCode() {
            return Objects.hash(this.types);
        }
    }
}

