/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnV5;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class NestedDataColumnSupplier
implements Supplier<NestedCommonFormatColumn> {
    private final String columnName;
    private final GenericIndexed<String> fields;
    private final FieldTypeInfo fieldInfo;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final ColumnConfig columnConfig;
    private final SmooshedFileMapper fileMapper;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ByteOrder byteOrder;
    @Nullable
    private final ColumnType simpleType;

    public static NestedDataColumnSupplier read(ColumnType logicalType, boolean hasNulls, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, BitmapSerdeFactory bitmapSerdeFactory, ByteOrder byteOrder) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version == 0) {
            try {
                ImmutableBitmap nullValues;
                SmooshedFileMapper mapper = columnBuilder.getFileMapper();
                GenericIndexed<String> fields = GenericIndexed.read(bb, GenericIndexed.STRING_STRATEGY, mapper);
                FieldTypeInfo fieldInfo = FieldTypeInfo.read(bb, fields.size());
                ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__stringDictionary");
                Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier = StringEncodingStrategies.getStringDictionarySupplier(mapper, stringDictionaryBuffer, byteOrder);
                ByteBuffer longDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__longDictionary");
                Supplier longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, ColumnType.LONG.getStrategy(), byteOrder, 8);
                ByteBuffer doubleDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__doubleDictionary");
                Supplier doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, ColumnType.DOUBLE.getStrategy(), byteOrder, 8);
                ByteBuffer arrayDictionarybuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__arrayDictionary");
                Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, byteOrder);
                ByteBuffer rawBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__raw");
                CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(NestedCommonFormatColumnSerializer.getInternalFileName(columnName, "__raw"), rawBuffer, byteOrder, mapper);
                if (hasNulls) {
                    columnBuilder.setHasNulls(true);
                    ByteBuffer nullIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__nullIndex");
                    nullValues = bitmapSerdeFactory.getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                } else {
                    nullValues = bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap();
                }
                return new NestedDataColumnSupplier(columnName, fields, fieldInfo, compressedRawColumnSupplier, nullValues, stringDictionarySupplier, longDictionarySupplier, doubleDictionarySupplier, arrayDictionarySupplier, columnConfig, mapper, bitmapSerdeFactory, byteOrder, logicalType);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private NestedDataColumnSupplier(String columnName, GenericIndexed<String> fields, FieldTypeInfo fieldInfo, CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, Supplier<? extends Indexed<ByteBuffer>> stringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, ColumnConfig columnConfig, SmooshedFileMapper fileMapper, BitmapSerdeFactory bitmapSerdeFactory, ByteOrder byteOrder, @Nullable ColumnType simpleType) {
        this.columnName = columnName;
        this.fields = fields;
        this.fieldInfo = fieldInfo;
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.nullValues = nullValues;
        this.stringDictionarySupplier = stringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.columnConfig = columnConfig;
        this.fileMapper = fileMapper;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.simpleType = simpleType;
    }

    public NestedCommonFormatColumn get() {
        return new NestedDataColumnV5<Indexed<ByteBuffer>>(this.columnName, this.getLogicalType(), this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    public ColumnType getLogicalType() {
        return this.simpleType == null ? ColumnType.NESTED_DATA : this.simpleType;
    }
}

