/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class ExpressionVirtualColumn
implements VirtualColumn {
    private static final Logger log = new Logger(ExpressionVirtualColumn.class);
    private final String name;
    private final String expression;
    @Nullable
    private final ColumnType outputType;
    private final Supplier<Expr> parsedExpression;
    private final Supplier<byte[]> cacheKey;

    @JsonCreator
    public ExpressionVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="outputType") @Nullable ColumnType outputType, @JacksonInject ExprMacroTable macroTable) {
        this(name, expression, outputType, Parser.lazyParse(expression, macroTable));
    }

    public ExpressionVirtualColumn(String name, String expression, Expr parsedExpression, @Nullable ColumnType outputType) {
        this(name, expression, outputType, (Supplier<Expr>)((Supplier)() -> parsedExpression));
    }

    public ExpressionVirtualColumn(String name, Expr parsedExpression, @Nullable ColumnType outputType) {
        this(name, parsedExpression.toString(), outputType, (Supplier<Expr>)((Supplier)() -> parsedExpression));
    }

    private ExpressionVirtualColumn(String name, String expression, @Nullable ColumnType outputType, Supplier<Expr> parsedExpression) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.expression = (String)Preconditions.checkNotNull((Object)expression, (Object)"expression");
        this.outputType = outputType;
        this.parsedExpression = parsedExpression;
        this.cacheKey = this.makeCacheKeySupplier();
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    @JsonProperty
    public ColumnType getOutputType() {
        return this.outputType;
    }

    @JsonIgnore
    @VisibleForTesting
    public Supplier<Expr> getParsedExpression() {
        return this.parsedExpression;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory columnSelectorFactory) {
        if (this.isDirectAccess(columnSelectorFactory)) {
            return columnSelectorFactory.makeDimensionSelector(dimensionSpec.withDimension(((Expr)this.parsedExpression.get()).getBindingIfIdentifier()));
        }
        return dimensionSpec.decorate(ExpressionSelectors.makeDimensionSelector(columnSelectorFactory, (Expr)this.parsedExpression.get(), dimensionSpec.getExtractionFn()));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeColumnValueSelector(((Expr)this.parsedExpression.get()).getBindingIfIdentifier());
        }
        ColumnCapabilities capabilities = this.capabilities(factory, this.name);
        if (capabilities.is(ValueType.STRING)) {
            return ExpressionSelectors.makeStringColumnValueSelector(factory, (Expr)this.parsedExpression.get());
        }
        return ExpressionSelectors.makeColumnValueSelector(factory, (Expr)this.parsedExpression.get());
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        if (this.isDirectAccess(inspector)) {
            return true;
        }
        ExpressionPlan plan = ExpressionPlanner.plan(inspector, (Expr)this.parsedExpression.get());
        return plan.is(ExpressionPlan.Trait.VECTORIZABLE);
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeSingleValueDimensionSelector(dimensionSpec.withDimension(((Expr)this.parsedExpression.get()).getBindingIfIdentifier()));
        }
        return ExpressionVectorSelectors.makeSingleValueDimensionVectorSelector(factory, (Expr)this.parsedExpression.get());
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeValueSelector(((Expr)this.parsedExpression.get()).getBindingIfIdentifier());
        }
        return ExpressionVectorSelectors.makeVectorValueSelector(factory, (Expr)this.parsedExpression.get());
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory) {
        if (this.isDirectAccess(factory)) {
            return factory.makeObjectSelector(((Expr)this.parsedExpression.get()).getBindingIfIdentifier());
        }
        return ExpressionVectorSelectors.makeVectorObjectSelector(factory, (Expr)this.parsedExpression.get());
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        if (ExpressionProcessing.processArraysAsMultiValueStrings() && this.outputType != null && this.outputType.isArray()) {
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setHasMultipleValues(true);
        }
        return new ColumnCapabilitiesImpl().setType(this.outputType == null ? ColumnType.FLOAT : this.outputType);
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        if (this.isDirectAccess(inspector)) {
            return inspector.getColumnCapabilities(((Expr)this.parsedExpression.get()).getBindingIfIdentifier());
        }
        ExpressionPlan plan = ExpressionPlanner.plan(inspector, (Expr)this.parsedExpression.get());
        ColumnCapabilities inferred = plan.inferColumnCapabilities(this.outputType);
        if (inferred != null) {
            if (this.outputType != null && inferred.getType() != this.outputType.getType()) {
                if (!inferred.isNumeric() && !this.outputType.isNumeric()) {
                    log.warn("Projected output type %s of expression %s does not match provided type %s", inferred.asTypeString(), this.expression, this.outputType);
                } else {
                    log.debug("Projected output type %s of expression %s does not match provided type %s", inferred.asTypeString(), this.expression, this.outputType);
                }
            }
            return inferred;
        }
        return this.capabilities(columnName);
    }

    @Override
    public List<String> requiredColumns() {
        return ((Expr)this.parsedExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionVirtualColumn that = (ExpressionVirtualColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.outputType, that.outputType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.outputType);
    }

    public String toString() {
        return "ExpressionVirtualColumn{name='" + this.name + '\'' + ", expression='" + this.expression + '\'' + ", outputType=" + this.outputType + '}';
    }

    private boolean isDirectAccess(ColumnInspector inspector) {
        if (((Expr)this.parsedExpression.get()).isIdentifier()) {
            ColumnCapabilities baseCapabilities = inspector.getColumnCapabilities(((Expr)this.parsedExpression.get()).getBindingIfIdentifier());
            if (this.outputType == null) {
                return true;
            }
            if (baseCapabilities != null && this.outputType.equals(baseCapabilities.toColumnType())) {
                return true;
            }
        }
        return false;
    }

    private Supplier<byte[]> makeCacheKeySupplier() {
        return Suppliers.memoize(() -> {
            CacheKeyBuilder builder = new CacheKeyBuilder(1).appendString(this.name).appendCacheable((Cacheable)this.parsedExpression.get());
            if (this.outputType != null) {
                builder.appendString(this.outputType.toString());
            }
            return builder.build();
        });
    }
}

