/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.File;
import java.io.IOException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorProvider;
import org.apache.druid.storage.local.LocalFileStorageConnector;

@JsonTypeName(value="local")
public class LocalFileStorageConnectorProvider
implements StorageConnectorProvider {
    @JsonProperty
    File basePath;

    @JsonCreator
    public LocalFileStorageConnectorProvider(@JsonProperty(value="basePath", required=true) File basePath) {
        this.basePath = basePath;
    }

    public StorageConnector get() {
        try {
            return new LocalFileStorageConnector(this.basePath);
        }
        catch (IOException e) {
            throw new IAE(e, "Unable to create storage connector [%s] for base path [%s]", LocalFileStorageConnector.class.getSimpleName(), this.basePath);
        }
    }
}

