/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CloseableUtils;

public class RunAllFullyWidget<T, ResultType> {
    private static final Logger log = new Logger(RunAllFullyWidget.class);
    private final ProcessorManager<T, ResultType> processorManager;
    private final FrameProcessorExecutor exec;
    private final int maxOutstandingProcessors;
    private final Bouncer bouncer;
    @Nullable
    private final String cancellationId;

    RunAllFullyWidget(ProcessorManager<T, ResultType> processorManager, FrameProcessorExecutor exec, int maxOutstandingProcessors, Bouncer bouncer, @Nullable String cancellationId) {
        this.processorManager = processorManager;
        this.exec = exec;
        this.maxOutstandingProcessors = maxOutstandingProcessors;
        this.bouncer = bouncer;
        this.cancellationId = cancellationId;
    }

    ListenableFuture<ResultType> run() {
        ListenableFuture<Optional<ProcessorAndCallback<T>>> nextProcessorFuture;
        try {
            nextProcessorFuture = this.processorManager.next();
            if (nextProcessorFuture.isDone() && !((Optional)nextProcessorFuture.get()).isPresent()) {
                ResultType retVal = this.processorManager.result();
                this.processorManager.close();
                return Futures.immediateFuture(retVal);
            }
        }
        catch (Throwable e) {
            CloseableUtils.closeAndSuppressExceptions(this.processorManager, e::addSuppressed);
            return Futures.immediateFailedFuture((Throwable)e);
        }
        RunAllFullyRunnable runnable = new RunAllFullyRunnable(nextProcessorFuture);
        for (int i = 0; i < this.maxOutstandingProcessors; ++i) {
            this.exec.getExecutorService().submit((Runnable)runnable);
        }
        return runnable.finishedFuture;
    }

    private class RunAllFullyRunnable
    implements Runnable {
        private final AtomicReference<Either<Throwable, ResultType>> finished = new AtomicReference();
        private final SettableFuture<ResultType> finishedFuture;
        private final Object runAllFullyLock = new Object();
        @GuardedBy(value="runAllFullyLock")
        ListenableFuture<Optional<ProcessorAndCallback<T>>> nextProcessorFuture;
        @GuardedBy(value="runAllFullyLock")
        int outstandingProcessors;
        @GuardedBy(value="runAllFullyLock")
        Set<ListenableFuture<?>> outstandingFutures = Collections.newSetFromMap(new IdentityHashMap());
        @Nullable
        @GuardedBy(value="runAllFullyLock")
        Queue<Bouncer.Ticket> bouncerTicketQueue = new ArrayDeque<Bouncer.Ticket>();
        @GuardedBy(value="runAllFullyLock")
        boolean didCleanup;

        private RunAllFullyRunnable(ListenableFuture<Optional<ProcessorAndCallback<T>>> nextProcessorFuture) {
            this.nextProcessorFuture = nextProcessorFuture;
            this.finishedFuture = RunAllFullyWidget.this.exec.registerCancelableFuture(SettableFuture.create(), false, RunAllFullyWidget.this.cancellationId);
            this.finishedFuture.addListener(() -> {
                if (this.finishedFuture.isCancelled()) {
                    try {
                        Object object = this.runAllFullyLock;
                        synchronized (object) {
                            ImmutableList.copyOf(this.outstandingFutures).forEach(f -> f.cancel(true));
                            this.cleanupIfNoMoreProcessors();
                        }
                    }
                    catch (Throwable e) {
                        log.warn(e, "Exception encountered while cleaning up canceled runAllFully execution", new Object[0]);
                    }
                }
            }, (Executor)Execs.directExecutor());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bouncer.Ticket nextTicket = null;
            Object object = this.runAllFullyLock;
            synchronized (object) {
                ProcessorAndCallback nextProcessor;
                try {
                    if (this.finished.get() != null) {
                        this.cleanupIfNoMoreProcessors();
                        return;
                    }
                    if (!this.nextProcessorFuture.isDone()) {
                        ListenableFuture futureRef = this.nextProcessorFuture;
                        futureRef.addListener(() -> {
                            if (!futureRef.isCancelled()) {
                                RunAllFullyWidget.this.exec.getExecutorService().submit((Runnable)this);
                            }
                        }, (Executor)Execs.directExecutor());
                        return;
                    }
                    Optional maybeNextProcessor = (Optional)this.nextProcessorFuture.get();
                    if (!maybeNextProcessor.isPresent()) {
                        if (this.outstandingProcessors == 0) {
                            this.finished.compareAndSet(null, Either.value(RunAllFullyWidget.this.processorManager.result()));
                            this.cleanupIfNoMoreProcessors();
                        }
                        return;
                    }
                    assert (this.bouncerTicketQueue != null);
                    Bouncer.Ticket ticketFromQueue = this.bouncerTicketQueue.poll();
                    if (ticketFromQueue != null) {
                        nextTicket = ticketFromQueue;
                    } else {
                        ListenableFuture<Bouncer.Ticket> ticketFuture = RunAllFullyWidget.this.exec.registerCancelableFuture(RunAllFullyWidget.this.bouncer.ticket(), false, RunAllFullyWidget.this.cancellationId);
                        if (ticketFuture.isDone() && !ticketFuture.isCancelled()) {
                            nextTicket = FutureUtils.getUncheckedImmediately(ticketFuture);
                        } else {
                            ticketFuture.addListener(() -> {
                                if (!ticketFuture.isCancelled()) {
                                    Bouncer.Ticket ticket = (Bouncer.Ticket)FutureUtils.getUncheckedImmediately(ticketFuture);
                                    Object object = this.runAllFullyLock;
                                    synchronized (object) {
                                        if (this.finished.get() != null) {
                                            ticket.giveBack();
                                            return;
                                        }
                                        this.bouncerTicketQueue.add(ticket);
                                    }
                                    RunAllFullyWidget.this.exec.getExecutorService().submit((Runnable)this);
                                }
                            }, (Executor)Execs.directExecutor());
                            return;
                        }
                    }
                    assert (this.outstandingProcessors < RunAllFullyWidget.this.maxOutstandingProcessors);
                    nextProcessor = (ProcessorAndCallback)maybeNextProcessor.get();
                    this.nextProcessorFuture = RunAllFullyWidget.this.processorManager.next();
                    ++this.outstandingProcessors;
                }
                catch (Throwable e) {
                    if (nextTicket != null) {
                        nextTicket.giveBack();
                    }
                    this.finished.compareAndSet(null, Either.error(e));
                    this.cleanupIfNoMoreProcessors();
                    return;
                }
                assert (nextTicket != null);
                assert (nextProcessor != null);
                final ListenableFuture future = RunAllFullyWidget.this.exec.runFully(FrameProcessors.withBaggage(nextProcessor.processor(), nextTicket::giveBack), RunAllFullyWidget.this.cancellationId);
                this.outstandingFutures.add(future);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(T result) {
                        boolean isDone;
                        Object object;
                        try {
                            object = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object) {
                                --RunAllFullyRunnable.this.outstandingProcessors;
                                RunAllFullyRunnable.this.outstandingFutures.remove(future);
                                isDone = RunAllFullyRunnable.this.outstandingProcessors == 0 && RunAllFullyRunnable.this.nextProcessorFuture.isDone() && !((Optional)RunAllFullyRunnable.this.nextProcessorFuture.get()).isPresent();
                                nextProcessor.onComplete(result);
                            }
                        }
                        catch (Throwable e) {
                            RunAllFullyRunnable.this.finished.compareAndSet(null, Either.error(e));
                            Object object2 = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object2) {
                                RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                            }
                            return;
                        }
                        if (isDone) {
                            RunAllFullyRunnable.this.finished.compareAndSet(null, Either.value(RunAllFullyWidget.this.processorManager.result()));
                            object = RunAllFullyRunnable.this.runAllFullyLock;
                            synchronized (object) {
                                RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                            }
                        } else {
                            RunAllFullyWidget.this.exec.getExecutorService().submit((Runnable)RunAllFullyRunnable.this);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFailure(Throwable t) {
                        RunAllFullyRunnable.this.finished.compareAndSet(null, Either.error(t));
                        Object object = RunAllFullyRunnable.this.runAllFullyLock;
                        synchronized (object) {
                            --RunAllFullyRunnable.this.outstandingProcessors;
                            RunAllFullyRunnable.this.outstandingFutures.remove(future);
                            RunAllFullyRunnable.this.cleanupIfNoMoreProcessors();
                        }
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }

        @GuardedBy(value="runAllFullyLock")
        private void cleanupIfNoMoreProcessors() {
            if (this.outstandingProcessors == 0 && this.finished.get() != null && !this.didCleanup) {
                this.cleanup();
            }
        }

        @GuardedBy(value="runAllFullyLock")
        private void cleanup() {
            assert (this.finished.get() != null);
            assert (this.outstandingProcessors == 0);
            Throwable caught = null;
            try {
                if (this.bouncerTicketQueue != null) {
                    Bouncer.Ticket ticket;
                    while ((ticket = this.bouncerTicketQueue.poll()) != null) {
                        ticket.giveBack();
                    }
                    this.bouncerTicketQueue = null;
                }
                RunAllFullyWidget.this.processorManager.close();
            }
            catch (Throwable e) {
                caught = e;
            }
            finally {
                this.didCleanup = true;
                if (this.finished.get().isValue()) {
                    if (caught != null) {
                        this.finishedFuture.setException(caught);
                    } else {
                        this.finishedFuture.set(this.finished.get().valueOrThrow());
                    }
                } else {
                    Throwable t = this.finished.get().error();
                    if (caught != null) {
                        t.addSuppressed(caught);
                    }
                    this.finishedFuture.setException(t);
                }
            }
        }
    }
}

