/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class FrameStorageAdapter
implements StorageAdapter {
    private final Frame frame;
    private final FrameReader frameReader;
    private final Interval interval;
    private final CursorFactory cursorFactory;

    public FrameStorageAdapter(Frame frame, FrameReader frameReader, Interval interval) {
        this.frame = frame;
        this.frameReader = frameReader;
        this.interval = interval;
        this.cursorFactory = frameReader.makeCursorFactory(frame);
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public RowSignature getRowSignature() {
        return this.frameReader.signature();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.frameReader.signature().getColumnNames());
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Collections.emptyList();
    }

    @Override
    public int getDimensionCardinality(String column) {
        return -1;
    }

    @Override
    public DateTime getMinTime() {
        return this.getInterval().getStart();
    }

    @Override
    public DateTime getMaxTime() {
        return this.getInterval().getEnd().minus(1L);
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.frameReader.columnCapabilities(this.frame, column);
    }

    @Override
    public int getNumRows() {
        return this.frame.numRows();
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    @Nullable
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public boolean canVectorize(@Nullable Filter filter, VirtualColumns virtualColumns, boolean descending) {
        return this.cursorFactory.canVectorize(filter, virtualColumns, descending);
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        return this.cursorFactory.makeCursors(filter, interval, virtualColumns, gran, descending, queryMetrics);
    }

    @Override
    @Nullable
    public VectorCursor makeVectorCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending, int vectorSize, @Nullable QueryMetrics<?> queryMetrics) {
        return this.cursorFactory.makeVectorCursor(filter, interval, virtualColumns, descending, vectorSize, queryMetrics);
    }
}

