/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    default public <R> CloseableIterator<R> map(final Function<T, R> mapFunction) {
        final CloseableIterator delegate = this;
        return new CloseableIterator<R>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapFunction.apply(delegate.next());
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    default public <R> CloseableIterator<R> flatMap(final Function<T, CloseableIterator<R>> function) {
        final CloseableIterator outerIterator = this;
        return new CloseableIterator<R>(){
            CloseableIterator<R> currInnerIterator = null;

            private void findNextIteratorIfNecessary() {
                while ((this.currInnerIterator == null || !this.currInnerIterator.hasNext()) && outerIterator.hasNext()) {
                    if (this.currInnerIterator != null) {
                        try {
                            this.currInnerIterator.close();
                            this.currInnerIterator = null;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    this.currInnerIterator = (CloseableIterator)function.apply(outerIterator.next());
                    if (!this.currInnerIterator.hasNext()) continue;
                    return;
                }
            }

            @Override
            public boolean hasNext() {
                this.findNextIteratorIfNecessary();
                return this.currInnerIterator != null && this.currInnerIterator.hasNext();
            }

            @Override
            public R next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.currInnerIterator.next();
            }

            @Override
            public void close() throws IOException {
                outerIterator.close();
                if (this.currInnerIterator != null) {
                    this.currInnerIterator.close();
                    this.currInnerIterator = null;
                }
            }
        };
    }
}

