/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.Cpu;

public class CgroupCpuMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;

    public CgroupCpuMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    public CgroupCpuMonitor(Map<String, String[]> dimensions, String feed) {
        this(null, dimensions, feed);
    }

    public CgroupCpuMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupCpuMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        Cpu cpu = new Cpu(this.cgroupDiscoverer);
        Cpu.CpuAllocationMetric cpuSnapshot = cpu.snapshot();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        emitter.emit(builder.setMetric("cgroup/cpu/shares", cpuSnapshot.getShares()));
        emitter.emit(builder.setMetric("cgroup/cpu/cores_quota", CgroupCpuMonitor.computeProcessorQuota(cpuSnapshot.getQuotaUs(), cpuSnapshot.getPeriodUs())));
        return true;
    }

    public static double computeProcessorQuota(long quotaUs, long periodUs) {
        return quotaUs < 0L || periodUs == 0L ? -1.0 : (double)quotaUs / (double)periodUs;
    }
}

