/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

class BigIntegerExpr
extends ConstantExpr<BigInteger> {
    public BigIntegerExpr(BigInteger value) {
        super(ExpressionType.LONG, (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"value"));
    }

    public String toString() {
        return ((BigInteger)this.value).toString();
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofLong(((BigInteger)this.value).longValueExact());
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigIntegerExpr otherExpr = (BigIntegerExpr)o;
        return ((BigInteger)this.value).equals(otherExpr.value);
    }

    public int hashCode() {
        return ((BigInteger)this.value).hashCode();
    }
}

