/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;

abstract class ConstantExpr<T>
implements Expr {
    final ExpressionType outputType;
    @Nullable
    final T value;

    protected ConstantExpr(ExpressionType outputType, @Nullable T value) {
        this.outputType = outputType;
        this.value = value;
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.value == null ? null : this.outputType;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isNullLiteral() {
        return this.value == null;
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return Expr.BindingAnalysis.EMTPY;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return true;
    }

    @Override
    public String stringify() {
        return this.toString();
    }
}

