/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class ObjectOutMultiObjectInVectorProcessor
implements ExprVectorProcessor<Object[]> {
    final ExprVectorProcessor<Object[]>[] inputs;
    final Object[] outValues;
    final ExpressionType expressionType;

    protected ObjectOutMultiObjectInVectorProcessor(ExprVectorProcessor<Object[]>[] inputs, int maxVectorSize, ExpressionType objectType) {
        this.inputs = inputs;
        this.outValues = new Object[maxVectorSize];
        this.expressionType = objectType;
    }

    @Override
    public ExpressionType getOutputType() {
        return this.expressionType;
    }

    @Override
    public ExprEvalVector<Object[]> evalVector(Expr.VectorInputBinding bindings) {
        int i;
        int currentSize = bindings.getCurrentVectorSize();
        Object[][] in = new Object[this.inputs.length][];
        for (i = 0; i < this.inputs.length; ++i) {
            in[i] = this.inputs[i].evalVector(bindings).values();
        }
        for (i = 0; i < currentSize; ++i) {
            this.processIndex(in, i);
        }
        return new ExprEvalObjectVector(this.outValues);
    }

    abstract void processIndex(Object[][] var1, int var2);
}

