/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.select.SelectQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="queryType")
@JsonSubTypes(value={@JsonSubTypes.Type(name="dataSourceMetadata", value=DataSourceMetadataQuery.class), @JsonSubTypes.Type(name="groupBy", value=GroupByQuery.class), @JsonSubTypes.Type(name="scan", value=ScanQuery.class), @JsonSubTypes.Type(name="search", value=SearchQuery.class), @JsonSubTypes.Type(name="segmentMetadata", value=SegmentMetadataQuery.class), @JsonSubTypes.Type(name="select", value=SelectQuery.class), @JsonSubTypes.Type(name="timeBoundary", value=TimeBoundaryQuery.class), @JsonSubTypes.Type(name="timeseries", value=TimeseriesQuery.class), @JsonSubTypes.Type(name="topN", value=TopNQuery.class), @JsonSubTypes.Type(name="windowOperator", value=WindowOperatorQuery.class)})
public interface Query<T> {
    public static final String DATASOURCE_METADATA = "dataSourceMetadata";
    public static final String GROUP_BY = "groupBy";
    public static final String SCAN = "scan";
    public static final String SEARCH = "search";
    public static final String SEGMENT_METADATA = "segmentMetadata";
    public static final String SELECT = "select";
    public static final String TIME_BOUNDARY = "timeBoundary";
    public static final String TIMESERIES = "timeseries";
    public static final String TOPN = "topN";
    public static final String WINDOW_OPERATOR = "windowOperator";

    public DataSource getDataSource();

    public boolean hasFilters();

    public DimFilter getFilter();

    public String getType();

    public QueryRunner<T> getRunner(QuerySegmentWalker var1);

    public List<Interval> getIntervals();

    public Duration getDuration();

    public Granularity getGranularity();

    public DateTimeZone getTimezone();

    public Map<String, Object> getContext();

    default public QueryContext context() {
        return QueryContext.of(this.getContext());
    }

    @Deprecated
    @Nullable
    default public <ContextType> ContextType getContextValue(String key) {
        return (ContextType)this.context().get(key);
    }

    @Deprecated
    default public boolean getContextBoolean(String key, boolean defaultValue) {
        return this.context().getBoolean(key, defaultValue);
    }

    @Deprecated
    default public HumanReadableBytes getContextHumanReadableBytes(String key, HumanReadableBytes defaultValue) {
        return this.context().getHumanReadableBytes(key, defaultValue);
    }

    public boolean isDescending();

    public Ordering<T> getResultOrdering();

    public Query<T> withOverriddenContext(Map<String, Object> var1);

    public Query<T> withQuerySegmentSpec(QuerySegmentSpec var1);

    public Query<T> withId(String var1);

    @Nullable
    public String getId();

    public Query<T> withSubQueryId(String var1);

    default public Query<T> withDefaultSubQueryId() {
        return this.withSubQueryId(UUID.randomUUID().toString());
    }

    @Nullable
    public String getSubQueryId();

    default public Query<T> withSqlQueryId(String sqlQueryId) {
        return this;
    }

    @Nullable
    default public String getSqlQueryId() {
        return this.context().getString("sqlQueryId");
    }

    default public String getMostSpecificId() {
        String subqueryId = this.getSubQueryId();
        return subqueryId == null ? (String)Preconditions.checkNotNull((Object)this.getId(), (Object)"queryId") : subqueryId;
    }

    public Query<T> withDataSource(DataSource var1);

    default public Query<T> optimizeForSegment(PerSegmentQueryOptimizationContext optimizationContext) {
        return this;
    }

    default public Query<T> withPriority(int priority) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"priority", (Object)priority));
    }

    default public Query<T> withLane(String lane) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"lane", (Object)lane));
    }

    default public VirtualColumns getVirtualColumns() {
        return VirtualColumns.EMPTY;
    }

    @Nullable
    default public Set<String> getRequiredColumns() {
        return null;
    }
}

