/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongStringDeltaEncodedStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellWriter;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SerializablePairLongStringBufferStore {
    private final SerializedStorage<SerializablePairLongString> serializedStorage;
    private long minValue = Long.MAX_VALUE;
    private long maxValue = Long.MIN_VALUE;

    public SerializablePairLongStringBufferStore(SerializedStorage<SerializablePairLongString> serializedStorage) {
        this.serializedStorage = serializedStorage;
    }

    public void store(@Nullable SerializablePairLongString pairLongString) throws IOException {
        if (pairLongString != null && pairLongString.lhs != null) {
            this.minValue = Math.min(this.minValue, (Long)pairLongString.lhs);
            this.maxValue = Math.max(this.maxValue, (Long)pairLongString.lhs);
        }
        this.serializedStorage.store(pairLongString);
    }

    public TransferredBuffer transferToRowWriter(ByteBufferProvider byteBufferProvider, SegmentWriteOutMedium segmentWriteOutMedium) throws IOException {
        SerializablePairLongStringColumnHeader columnHeader = this.createColumnHeader();
        SerializablePairLongStringDeltaEncodedStagedSerde serde = new SerializablePairLongStringDeltaEncodedStagedSerde(columnHeader.getMinValue(), columnHeader.isUseIntegerDeltas());
        try (CellWriter cellWriter = new CellWriter.Builder(segmentWriteOutMedium).setByteBufferProvider(byteBufferProvider).build();){
            TransferredBuffer transferredBuffer;
            block13: {
                IOIterator<SerializablePairLongString> bufferIterator = this.iterator();
                try {
                    while (bufferIterator.hasNext()) {
                        SerializablePairLongString pairLongString = bufferIterator.next();
                        byte[] serialized = serde.serialize(pairLongString);
                        cellWriter.write(serialized);
                    }
                    cellWriter.close();
                    transferredBuffer = new TransferredBuffer(cellWriter, columnHeader);
                    if (bufferIterator == null) break block13;
                }
                catch (Throwable throwable) {
                    if (bufferIterator != null) {
                        try {
                            bufferIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bufferIterator.close();
            }
            return transferredBuffer;
        }
    }

    @Nonnull
    public SerializablePairLongStringColumnHeader createColumnHeader() {
        long maxDelta = this.maxValue - this.minValue;
        if (this.minValue < this.maxValue && maxDelta < 0L || this.minValue > this.maxValue) {
            maxDelta = Long.MAX_VALUE;
            this.minValue = 0L;
        }
        SerializablePairLongStringColumnHeader columnHeader = maxDelta <= Integer.MAX_VALUE ? new SerializablePairLongStringColumnHeader(3, true, this.minValue) : new SerializablePairLongStringColumnHeader(3, false, this.minValue);
        return columnHeader;
    }

    public IOIterator<SerializablePairLongString> iterator() throws IOException {
        return this.serializedStorage.iterator();
    }

    public static class TransferredBuffer
    implements Serializer {
        private final CellWriter cellWriter;
        private final SerializablePairLongStringColumnHeader columnHeader;

        public TransferredBuffer(CellWriter cellWriter, SerializablePairLongStringColumnHeader columnHeader) {
            this.cellWriter = cellWriter;
            this.columnHeader = columnHeader;
        }

        @Override
        public void writeTo(WritableByteChannel channel, @Nullable FileSmoosher smoosher) throws IOException {
            this.columnHeader.transferTo(channel);
            this.cellWriter.writeTo(channel, smoosher);
        }

        @Override
        public long getSerializedSize() {
            return (long)this.columnHeader.getSerializedSize() + this.cellWriter.getSerializedSize();
        }
    }
}

