/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.query.aggregation.SerializablePairLongStringDeltaEncodedStagedSerde;
import org.apache.druid.segment.serde.cell.LongSerializer;

public class SerializablePairLongStringColumnHeader {
    private static final int HEADER_SIZE_BYTES = 4;
    private static final int USE_INTEGER_MASK = 128;
    private static final int VERSION_INDEX = 0;
    private static final int ENCODING_INDEX = 1;
    private final byte[] bytes;
    private final long minValue;

    private SerializablePairLongStringColumnHeader(byte[] bytes, long minTimestamp) {
        this.bytes = bytes;
        this.minValue = minTimestamp;
    }

    public SerializablePairLongStringColumnHeader(int version, boolean useIntegerDeltas, long minTimestamp) {
        this.minValue = minTimestamp;
        this.bytes = new byte[4];
        Preconditions.checkArgument((version <= 255 ? 1 : 0) != 0, (Object)"max version 255");
        this.bytes[0] = (byte)version;
        if (useIntegerDeltas) {
            this.bytes[1] = (byte)(this.bytes[1] | 0x80);
        }
    }

    public static SerializablePairLongStringColumnHeader fromBuffer(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[4];
        byteBuffer.get(bytes);
        long minTimestamp = byteBuffer.getLong();
        return new SerializablePairLongStringColumnHeader(bytes, minTimestamp);
    }

    public SerializablePairLongStringDeltaEncodedStagedSerde createSerde() {
        return new SerializablePairLongStringDeltaEncodedStagedSerde(this.minValue, this.isUseIntegerDeltas());
    }

    public void transferTo(WritableByteChannel channel) throws IOException {
        LongSerializer longSerializer = new LongSerializer();
        channel.write(ByteBuffer.wrap(this.bytes));
        channel.write(longSerializer.serialize(this.minValue));
    }

    public int getVersion() {
        return 0xFF & this.bytes[0];
    }

    public boolean isUseIntegerDeltas() {
        return (this.bytes[1] & 0x80) != 0;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public int getSerializedSize() {
        return 12;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytes", (Object)this.bytes).add("minValue", this.minValue).toString();
    }
}

