/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringAnyAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector valueSelector;
    private final int maxStringBytes;
    private boolean isFound;
    private String foundValue;

    public StringAnyAggregator(BaseObjectColumnValueSelector valueSelector, int maxStringBytes) {
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
        this.foundValue = null;
        this.isFound = false;
    }

    @Override
    public void aggregate() {
        if (!this.isFound) {
            Object object = this.valueSelector.getObject();
            this.foundValue = DimensionHandlerUtils.convertObjectToString(object);
            if (this.foundValue != null && this.foundValue.length() > this.maxStringBytes) {
                this.foundValue = this.foundValue.substring(0, this.maxStringBytes);
            }
            this.isFound = true;
        }
    }

    @Override
    public Object get() {
        return StringUtils.chop(this.foundValue, this.maxStringBytes);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringAnyAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

