/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.first.NumericFirstVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongFirstVectorAggregator
extends NumericFirstVectorAggregator {
    public LongFirstVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        long firstValue = this.valueSelector.getLongVector()[index];
        buf.putLong(position, firstValue);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair<Long, Object>(buf.getLong(position), (rhsNull ? null : Long.valueOf(buf.getLong(position + 9))));
    }
}

