/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NumericFirstVectorAggregator
implements VectorAggregator {
    static final int NULL_OFFSET = 8;
    static final int VALUE_OFFSET = 9;
    final VectorValueSelector valueSelector;
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final VectorValueSelector timeSelector;
    private long firstTime;

    public NumericFirstVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.firstTime = Long.MAX_VALUE;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        this.initValue(buf, position + 9);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        boolean[] nullValueVector = this.valueSelector.getNullVector();
        this.firstTime = buf.getLong(position);
        for (int i = startRow; i < endRow; ++i) {
            long earliestTime;
            int index = i;
            if (nullTimeVector != null && nullTimeVector[index] || (earliestTime = timeVector[index]) >= this.firstTime) continue;
            this.firstTime = earliestTime;
            if (this.useDefault || nullValueVector == null || !nullValueVector[index]) {
                this.updateTimeWithValue(buf, position, this.firstTime, index);
                continue;
            }
            this.updateTimeWithNull(buf, position, this.firstTime);
        }
    }

    boolean isValueNull(ByteBuffer buf, int position) {
        return buf.get(position + 8) == 1;
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        boolean[] nulls = this.useDefault ? null : this.valueSelector.getNullVector();
        long[] timeVector = this.timeSelector.getLongVector();
        for (int i = 0; i < numRows; ++i) {
            int position;
            long firstTime;
            int row = rows == null ? i : rows[i];
            if (timeVector[row] >= (firstTime = buf.getLong(position = positions[i] + positionOffset))) continue;
            if (this.useDefault || nulls == null || !nulls[row]) {
                this.updateTimeWithValue(buf, position, timeVector[row], row);
                continue;
            }
            this.updateTimeWithNull(buf, position, timeVector[row]);
        }
    }

    void updateTimeWithValue(ByteBuffer buf, int position, long time, int index) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        this.putValue(buf, position + 9, index);
    }

    void updateTimeWithNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract void putValue(ByteBuffer var1, int var2, int var3);

    @Override
    public void close() {
    }
}

