/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class SingleStringFirstDimensionVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector timeSelector;
    private final SingleValueDimensionVectorSelector valueDimensionVectorSelector;
    private long firstTime;
    private final int maxStringBytes;
    private final boolean useDefault = NullHandling.replaceWithDefault();

    public SingleStringFirstDimensionVectorAggregator(VectorValueSelector timeSelector, SingleValueDimensionVectorSelector valueDimensionVectorSelector, int maxStringBytes) {
        this.timeSelector = timeSelector;
        this.valueDimensionVectorSelector = valueDimensionVectorSelector;
        this.maxStringBytes = maxStringBytes;
        this.firstTime = Long.MAX_VALUE;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MAX_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        buf.putInt(position + 9, 0);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        int[] valueVector = this.valueDimensionVectorSelector.getRowVector();
        this.firstTime = buf.getLong(position);
        for (int index = startRow; index < endRow; ++index) {
            long earliestTime;
            if (nullTimeVector != null && nullTimeVector[index] || (earliestTime = timeVector[index]) >= this.firstTime) continue;
            this.firstTime = earliestTime;
            buf.putLong(position, this.firstTime);
            buf.put(position + 8, (byte)0);
            buf.putInt(position + 9, valueVector[index]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        int[] values = this.valueDimensionVectorSelector.getRowVector();
        for (int i = 0; i < numRows; ++i) {
            int position;
            long firstTime;
            if (nullTimeVector != null && nullTimeVector[i]) continue;
            int row = rows == null ? i : rows[i];
            if (timeVector[row] >= (firstTime = buf.getLong(position = positions[i] + positionOffset))) continue;
            firstTime = timeVector[row];
            buf.putLong(position, firstTime);
            buf.put(position + 8, (byte)0);
            buf.putInt(position + 9, values[row]);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        int index = buf.getInt(position + 9);
        long earliest = buf.getLong(position);
        String strValue = this.valueDimensionVectorSelector.lookupName(index);
        return new SerializablePairLongString(earliest, StringUtils.chop(strValue, this.maxStringBytes));
    }

    @Override
    public void close() {
    }
}

