/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.timeline.partition.ShardSpec;

public class DimFilterUtils {
    static final byte SELECTOR_CACHE_ID = 0;
    static final byte AND_CACHE_ID = 1;
    static final byte OR_CACHE_ID = 2;
    static final byte NOT_CACHE_ID = 3;
    static final byte EXTRACTION_CACHE_ID = 4;
    static final byte REGEX_CACHE_ID = 5;
    static final byte SEARCH_QUERY_TYPE_ID = 6;
    static final byte JAVASCRIPT_CACHE_ID = 7;
    static final byte SPATIAL_CACHE_ID = 8;
    static final byte IN_CACHE_ID = 9;
    static final byte BOUND_CACHE_ID = 10;
    static final byte INTERVAL_CACHE_ID = 11;
    static final byte LIKE_CACHE_ID = 12;
    static final byte COLUMN_COMPARISON_CACHE_ID = 13;
    static final byte EXPRESSION_CACHE_ID = 14;
    static final byte TRUE_CACHE_ID = 15;
    static final byte FALSE_CACHE_ID = 17;
    public static final byte BLOOM_DIM_FILTER_CACHE_ID = 16;
    static final byte NULL_CACHE_ID = 18;
    static final byte EQUALS_CACHE_ID = 19;
    static final byte RANGE_CACHE_ID = 20;
    static final byte IS_FILTER_BOOLEAN_FILTER_CACHE_ID = 21;
    public static final byte STRING_SEPARATOR = -1;

    static byte[] computeCacheKey(byte cacheIdKey, List<DimFilter> filters) {
        if (filters.size() == 1) {
            return filters.get(0).getCacheKey();
        }
        byte[][] cacheKeys = new byte[filters.size()][];
        int totalSize = 0;
        int index = 0;
        for (DimFilter field : filters) {
            cacheKeys[index] = field.getCacheKey();
            totalSize += cacheKeys[index].length;
            ++index;
        }
        ByteBuffer retVal = ByteBuffer.allocate(1 + totalSize);
        retVal.put(cacheIdKey);
        for (byte[] cacheKey : cacheKeys) {
            retVal.put(cacheKey);
        }
        return retVal.array();
    }

    public static <T> Set<T> filterShards(DimFilter dimFilter, Iterable<T> input, Function<T, ShardSpec> converter) {
        return DimFilterUtils.filterShards(dimFilter, input, converter, new HashMap<String, Optional<RangeSet<String>>>());
    }

    public static <T> Set<T> filterShards(DimFilter dimFilter, Iterable<T> input, Function<T, ShardSpec> converter, Map<String, Optional<RangeSet<String>>> dimensionRangeCache) {
        LinkedHashSet<T> retSet = new LinkedHashSet<T>();
        for (T obj : input) {
            ShardSpec shard = (ShardSpec)converter.apply(obj);
            boolean include = true;
            if (dimFilter != null && shard != null) {
                HashMap<String, RangeSet<String>> filterDomain = new HashMap<String, RangeSet<String>>();
                List<String> dimensions = shard.getDomainDimensions();
                for (String dimension : dimensions) {
                    Optional optFilterRangeSet = dimensionRangeCache.computeIfAbsent(dimension, d -> Optional.ofNullable(dimFilter.getDimensionRangeSet((String)d)));
                    if (!optFilterRangeSet.isPresent()) continue;
                    filterDomain.put(dimension, (RangeSet<String>)((RangeSet)optFilterRangeSet.get()));
                }
                if (!filterDomain.isEmpty() && !shard.possibleInDomain(filterDomain)) {
                    include = false;
                }
            }
            if (!include) continue;
            retSet.add(obj);
        }
        return retSet;
    }
}

