/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.ExpressionFilter;

public class ExpressionDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final String expression;
    private final Supplier<Expr> parsed;
    private final Supplier<byte[]> cacheKey;
    @Nullable
    private final FilterTuning filterTuning;

    @JsonCreator
    public ExpressionDimFilter(@JsonProperty(value="expression") String expression, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning, @JacksonInject ExprMacroTable macroTable) {
        this(expression, Parser.lazyParse(expression, macroTable), filterTuning);
    }

    public ExpressionDimFilter(String expression, ExprMacroTable macroTable) {
        this(expression, Parser.lazyParse(expression, macroTable), null);
    }

    public ExpressionDimFilter(String expression, Expr parsed, @Nullable FilterTuning filterTuning) {
        this(expression, (Supplier<Expr>)((Supplier)() -> parsed), filterTuning);
    }

    private ExpressionDimFilter(String expression, Supplier<Expr> parsed, @Nullable FilterTuning filterTuning) {
        this.expression = expression;
        this.parsed = parsed;
        this.filterTuning = filterTuning;
        this.cacheKey = Suppliers.memoize(() -> new CacheKeyBuilder(14).appendCacheable((Cacheable)parsed.get()).build());
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new ExpressionFilter(this.parsed, this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ((Expr)this.parsed.get()).analyzeInputs().getRequiredBindings();
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public String toString() {
        return "ExpressionDimFilter{expression='" + this.expression + '\'' + ", filterTuning=" + this.filterTuning + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionDimFilter that = (ExpressionDimFilter)o;
        return this.expression.equals(that.expression) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.filterTuning);
    }
}

